/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.threerings.openal.SoundManager;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public class Buffer {
    protected SoundManager _soundmgr;
    protected int _id;

    public Buffer(SoundManager soundmgr) {
        this._soundmgr = soundmgr;
        IntBuffer idbuf = BufferUtils.createIntBuffer((int)1);
        AL10.alGenBuffers((IntBuffer)idbuf);
        this._id = idbuf.get(0);
    }

    public final int getId() {
        return this._id;
    }

    public void setData(int format, ByteBuffer data, int frequency) {
        AL10.alBufferData((int)this._id, (int)format, (ByteBuffer)data, (int)frequency);
    }

    public void setData(int format, IntBuffer data, int frequency) {
        AL10.alBufferData((int)this._id, (int)format, (IntBuffer)data, (int)frequency);
    }

    public void setData(int format, ShortBuffer data, int frequency) {
        AL10.alBufferData((int)this._id, (int)format, (ShortBuffer)data, (int)frequency);
    }

    public int getSize() {
        return AL10.alGetBufferi((int)this._id, (int)8196);
    }

    public void delete() {
        IntBuffer idbuf = BufferUtils.createIntBuffer((int)1);
        idbuf.put(this._id).rewind();
        AL10.alDeleteBuffers((IntBuffer)idbuf);
        this._id = 0;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._id > 0) {
            this._soundmgr.bufferFinalized(this._id);
        }
    }
}

