/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.sprite;

import com.threerings.media.image.Mirage;
import com.threerings.media.sprite.ImageSprite;
import com.threerings.media.util.MultiFrameImage;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;

public class OrientableImageSprite
extends ImageSprite {
    public OrientableImageSprite() {
    }

    public OrientableImageSprite(Mirage image) {
        super(image);
    }

    public OrientableImageSprite(MultiFrameImage frames) {
        super(frames);
    }

    private AffineTransform getRotationTransform() {
        double theta;
        switch (this._orient) {
            default: {
                theta = 0.0;
                break;
            }
            case 7: {
                theta = Math.PI;
                break;
            }
            case 5: {
                theta = 1.5707963267948966;
                break;
            }
            case 1: {
                theta = -1.5707963267948966;
                break;
            }
            case 4: {
                theta = 0.7853981633974483;
                break;
            }
            case 2: {
                theta = -0.7853981633974483;
                break;
            }
            case 6: {
                theta = 2.356194490192345;
                break;
            }
            case 0: {
                theta = -2.356194490192345;
                break;
            }
            case 11: {
                theta = -0.39269908169872414;
                break;
            }
            case 10: {
                theta = 0.39269908169872414;
                break;
            }
            case 14: {
                theta = -2.748893571891069;
                break;
            }
            case 15: {
                theta = 2.748893571891069;
                break;
            }
            case 12: {
                theta = -1.1780972450961724;
                break;
            }
            case 13: {
                theta = -1.9634954084936207;
                break;
            }
            case 9: {
                theta = 1.1780972450961724;
                break;
            }
            case 8: {
                theta = 1.9634954084936207;
            }
        }
        return AffineTransform.getRotateInstance(theta, this._ox - this._oxoff + this._frames.getWidth(this._frameIdx) / 2, this._oy - this._oyoff + this._frames.getHeight(this._frameIdx) / 2);
    }

    protected void accomodateFrame(int frameIdx, int width, int height) {
        Area area = new Area(new Rectangle(this._ox - this._oxoff, this._oy - this._oyoff, width, height));
        area.transform(this.getRotationTransform());
        this._bounds = area.getBounds();
    }

    public void setOrientation(int orient) {
        super.setOrientation(orient);
        this.layout();
    }

    public void paint(Graphics2D graphics) {
        AffineTransform at = graphics.getTransform();
        graphics.transform(this.getRotationTransform());
        if (this._frames != null) {
            this._frames.paintFrame(graphics, this._frameIdx, this._ox - this._oxoff, this._oy - this._oyoff);
        } else {
            super.paint(graphics);
        }
        graphics.setTransform(at);
    }
}

