/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.samskivert.util.ConfigUtil;
import com.samskivert.util.LRUHashMap;
import com.samskivert.util.StringUtil;
import com.threerings.media.Log;
import com.threerings.media.image.ImageUtil;
import com.threerings.media.tile.TileIcon;
import com.threerings.media.tile.TileManager;
import com.threerings.media.tile.TileSet;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconManager {
    protected TileManager _tilemgr;
    protected Properties _config;
    protected String _rsrcSet;
    protected Map<String, TileSet> _icons = new LRUHashMap(10);
    protected static final String PATH_SUFFIX = ".path";
    protected static final String METRICS_SUFFIX = ".metrics";
    protected static final int ICON_CACHE_SIZE = 10;

    public IconManager(TileManager tmgr, String configPath) throws IOException {
        this(tmgr, ConfigUtil.loadProperties((String)configPath));
    }

    public IconManager(TileManager tmgr, Properties config) {
        this._tilemgr = tmgr;
        this._config = config;
    }

    public void setSource(String resourceSet) {
        this._rsrcSet = resourceSet;
    }

    public Icon getIcon(String iconSet, int index) {
        try {
            TileSet set = this._icons.get(iconSet);
            if (set == null) {
                String path = this._config.getProperty(iconSet + PATH_SUFFIX);
                if (StringUtil.isBlank((String)path)) {
                    throw new Exception("No path specified for icon set");
                }
                String metstr = this._config.getProperty(iconSet + METRICS_SUFFIX);
                if (StringUtil.isBlank((String)metstr)) {
                    throw new Exception("No metrics specified for icon set");
                }
                int[] metrics = StringUtil.parseIntArray((String)metstr);
                if (metrics == null || metrics.length != 2) {
                    throw new Exception("Invalid icon set metrics [metrics=" + metstr + "]");
                }
                set = this._rsrcSet == null ? this._tilemgr.loadTileSet(path, metrics[0], metrics[1]) : this._tilemgr.loadTileSet(this._rsrcSet, path, metrics[0], metrics[1]);
                this._icons.put(iconSet, set);
            }
            return new TileIcon(set.getTile(index));
        }
        catch (Exception e) {
            Log.log.warning((Object)("Unable to load icon [iconSet=" + iconSet + ", index=" + index + ", error=" + e + "]."), new Object[0]);
            return new ImageIcon(ImageUtil.createErrorImage(32, 32));
        }
    }
}

