/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.tile.tools.xml;

import com.samskivert.util.StringUtil;
import com.samskivert.xml.SetPropertyFieldsRule;
import com.samskivert.xml.ValidatedSetNextRule;
import com.threerings.media.tile.TileSetIDBroker;
import com.threerings.miso.Log;
import com.threerings.miso.tile.FringeConfiguration;
import com.threerings.tools.xml.CompiledConfigParser;
import java.io.Serializable;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

public class FringeConfigurationParser
extends CompiledConfigParser {
    protected TileSetIDBroker _idBroker;

    public FringeConfigurationParser(TileSetIDBroker broker) {
        this._idBroker = broker;
    }

    @Override
    protected Serializable createConfigObject() {
        return new FringeConfiguration();
    }

    @Override
    protected void addRules(Digester digest) {
        String prefix = "fringe";
        digest.addRule(prefix, (Rule)new SetPropertyFieldsRule());
        prefix = String.valueOf(prefix) + "/base";
        digest.addObjectCreate(prefix, FringeConfiguration.FringeRecord.class.getName());
        Object val = new ValidatedSetNextRule.Validator(){

            public boolean isValid(Object target) {
                if (((FringeConfiguration.FringeRecord)target).isValid()) {
                    return true;
                }
                Log.log.warning((Object)("A FringeRecord was not added because it was improperly specified [rec=" + target + "]."), new Object[0]);
                return false;
            }
        };
        ValidatedSetNextRule vrule = new ValidatedSetNextRule("addFringeRecord", (ValidatedSetNextRule.Validator)val){

            public void begin(String namespace, String lname, Attributes attrs) throws Exception {
                FringeConfiguration.FringeRecord frec = (FringeConfiguration.FringeRecord)this.digester.peek();
                int ii = 0;
                while (ii < attrs.getLength()) {
                    String name = attrs.getLocalName(ii);
                    if (StringUtil.isBlank((String)name)) {
                        name = attrs.getQName(ii);
                    }
                    String value = attrs.getValue(ii);
                    if ("name".equals(name)) {
                        if (FringeConfigurationParser.this._idBroker.tileSetMapped(value)) {
                            frec.base_tsid = FringeConfigurationParser.this._idBroker.getTileSetID(value);
                        } else {
                            Log.log.warning((Object)("Skipping unknown base tileset [name=" + value + "]."), new Object[0]);
                        }
                    } else if ("priority".equals(name)) {
                        frec.priority = Integer.parseInt(value);
                    } else {
                        Log.log.warning((Object)("Skipping unknown attribute [name=" + name + "]."), new Object[0]);
                    }
                    ++ii;
                }
            }
        };
        digest.addRule(prefix, (Rule)vrule);
        prefix = String.valueOf(prefix) + "/tileset";
        digest.addObjectCreate(prefix, FringeConfiguration.FringeTileSetRecord.class.getName());
        val = new ValidatedSetNextRule.Validator(){

            public boolean isValid(Object target) {
                if (((FringeConfiguration.FringeTileSetRecord)target).isValid()) {
                    return true;
                }
                Log.log.warning((Object)("A FringeTileSetRecord was not added because it was improperly specified [rec=" + target + "]."), new Object[0]);
                return false;
            }
        };
        vrule = new ValidatedSetNextRule("addTileset", (ValidatedSetNextRule.Validator)val){

            public void begin(String namespace, String lname, Attributes attrs) throws Exception {
                FringeConfiguration.FringeTileSetRecord f = (FringeConfiguration.FringeTileSetRecord)this.digester.peek();
                int ii = 0;
                while (ii < attrs.getLength()) {
                    String name = attrs.getLocalName(ii);
                    if (StringUtil.isBlank((String)name)) {
                        name = attrs.getQName(ii);
                    }
                    String value = attrs.getValue(ii);
                    if ("name".equals(name)) {
                        if (FringeConfigurationParser.this._idBroker.tileSetMapped(value)) {
                            f.fringe_tsid = FringeConfigurationParser.this._idBroker.getTileSetID(value);
                        } else {
                            Log.log.warning((Object)("Skipping unknown fringe tileset [name=" + value + "]."), new Object[0]);
                        }
                    } else if ("mask".equals(name)) {
                        f.mask = Boolean.valueOf(value);
                    } else {
                        Log.log.warning((Object)("Skipping unknown attribute [name=" + name + "]."), new Object[0]);
                    }
                    ++ii;
                }
            }
        };
        digest.addRule(prefix, (Rule)vrule);
    }
}

