/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.tools.xml;

import com.megginson.sax.DataWriter;
import com.samskivert.util.StringUtil;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.miso.data.SparseMisoSceneModel;
import com.threerings.tools.xml.NestableWriter;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SparseMisoSceneWriter
implements NestableWriter {
    public static final String OUTER_ELEMENT = "miso";

    public void write(Object object, DataWriter writer) throws SAXException {
        SparseMisoSceneModel model = (SparseMisoSceneModel)object;
        writer.startElement(OUTER_ELEMENT);
        this.writeSceneData(model, writer);
        writer.endElement(OUTER_ELEMENT);
    }

    protected void writeSceneData(SparseMisoSceneModel model, DataWriter writer) throws SAXException {
        writer.dataElement("swidth", Integer.toString(model.swidth));
        writer.dataElement("sheight", Integer.toString(model.sheight));
        writer.dataElement("defTileSet", Integer.toString(model.defTileSet));
        writer.startElement("sections");
        Iterator iter = model.getSections();
        while (iter.hasNext()) {
            SparseMisoSceneModel.Section sect = (SparseMisoSceneModel.Section)iter.next();
            if (sect.isBlank()) continue;
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "x", "", "", String.valueOf(sect.x));
            attrs.addAttribute("", "y", "", "", String.valueOf(sect.y));
            attrs.addAttribute("", "width", "", "", String.valueOf(sect.width));
            writer.startElement("", "section", "", (Attributes)attrs);
            writer.dataElement("base", StringUtil.toString((Object)sect.baseTileIds, (String)"", (String)""));
            writer.startElement("objects");
            int ii = 0;
            while (ii < sect.objectTileIds.length) {
                attrs = new AttributesImpl();
                attrs.addAttribute("", "tileId", "", "", String.valueOf(sect.objectTileIds[ii]));
                attrs.addAttribute("", "x", "", "", String.valueOf(sect.objectXs[ii]));
                attrs.addAttribute("", "y", "", "", String.valueOf(sect.objectYs[ii]));
                writer.emptyElement("", "object", "", (Attributes)attrs);
                ++ii;
            }
            ObjectInfo[] objectInfoArray = sect.objectInfo;
            int n = sect.objectInfo.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectInfo element = objectInfoArray[n2];
                SparseMisoSceneWriter.writeInterestingObject(element, writer);
                ++n2;
            }
            writer.endElement("objects");
            writer.endElement("section");
        }
        writer.endElement("sections");
    }

    public static void writeInterestingObject(ObjectInfo info, DataWriter writer) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "tileId", "", "", String.valueOf(info.tileId));
        attrs.addAttribute("", "x", "", "", String.valueOf(info.x));
        attrs.addAttribute("", "y", "", "", String.valueOf(info.y));
        if (!StringUtil.isBlank((String)info.action)) {
            attrs.addAttribute("", "action", "", "", info.action);
        }
        if (info.priority != 0) {
            attrs.addAttribute("", "priority", "", "", String.valueOf(info.priority));
        }
        if (info.sx != 0 || info.sy != 0) {
            attrs.addAttribute("", "sx", "", "", String.valueOf(info.sx));
            attrs.addAttribute("", "sy", "", "", String.valueOf(info.sy));
            attrs.addAttribute("", "sorient", "", "", String.valueOf(info.sorient));
        }
        if (info.zations != 0) {
            attrs.addAttribute("", "zations", "", "", String.valueOf(info.zations));
        }
        writer.emptyElement("", "object", "", (Attributes)attrs);
    }
}

