/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.tile.tools.xml;

import com.samskivert.util.StringUtil;
import com.samskivert.xml.CallMethodSpecialRule;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.tools.xml.SwissArmyTileSetRuleSet;
import com.threerings.miso.Log;
import com.threerings.miso.tile.BaseTileSet;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTileSetRuleSet
extends SwissArmyTileSetRuleSet {
    @Override
    public void addRuleInstances(Digester digester) {
        super.addRuleInstances(digester);
        digester.addRule(String.valueOf(this._path) + "/passable", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                int[] values = StringUtil.parseIntArray((String)bodyText);
                boolean[] passable = new boolean[values.length];
                int ii = 0;
                while (ii < values.length) {
                    passable[ii] = values[ii] != 0;
                    ++ii;
                }
                BaseTileSet starget = (BaseTileSet)target;
                starget.setPassability(passable);
            }
        });
    }

    @Override
    public boolean isValid(Object target) {
        BaseTileSet set = (BaseTileSet)target;
        boolean valid = super.isValid(target);
        if (set.getPassability() == null) {
            Log.log.warning((Object)("Tile set definition missing valid <passable> element [set=" + set + "]."), new Object[0]);
            valid = false;
        }
        return valid;
    }

    @Override
    protected Class<? extends TileSet> getTileSetClass() {
        return BaseTileSet.class;
    }
}

