/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile.tools.xml;

import com.google.common.collect.Lists;
import com.samskivert.util.ConfigUtil;
import com.samskivert.xml.ValidatedSetNextRule;
import com.threerings.media.Log;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.tools.xml.TileSetRuleSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTileSetParser {
    protected Digester _digester = new Digester();

    public void addRuleSet(String prefix, TileSetRuleSet ruleset) {
        ruleset.setPrefix(prefix);
        this._digester.addRuleSet((RuleSet)ruleset);
        this._digester.addRule(ruleset.getPath(), (Rule)new ValidatedSetNextRule("add", Object.class, (ValidatedSetNextRule.Validator)ruleset));
    }

    public void loadTileSets(String path, Map<String, TileSet> tilesets) throws IOException {
        InputStream is = ConfigUtil.getStream((String)path);
        if (is == null) {
            String errmsg = "Can't load tileset description file from classpath [path=" + path + "].";
            throw new FileNotFoundException(errmsg);
        }
        this.loadTileSets(is, tilesets);
    }

    public void loadTileSets(File file, Map<String, TileSet> tilesets) throws IOException {
        this.loadTileSets(new FileInputStream(file), tilesets);
    }

    public void loadTileSets(InputStream source, Map<String, TileSet> tilesets) throws IOException {
        ArrayList setlist = Lists.newArrayList();
        this._digester.push((Object)setlist);
        try {
            this._digester.parse(source);
        }
        catch (SAXException saxe) {
            Log.log.warning((Object)"Exception parsing tile set descriptions.", new Object[]{saxe});
        }
        int ii = 0;
        while (ii < setlist.size()) {
            TileSet set = (TileSet)setlist.get(ii);
            if (set.getName() == null) {
                Log.log.warning((Object)("Tileset did not receive name during parsing process [set=" + set + "]."), new Object[0]);
            } else {
                tilesets.put(set.getName(), set);
            }
            ++ii;
        }
        setlist.clear();
    }
}

