/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.tile.tools;

import com.samskivert.io.PersistenceException;
import com.threerings.media.tile.tools.MapFileTileSetIDBroker;
import com.threerings.miso.tile.tools.xml.FringeConfigurationParser;
import com.threerings.util.CompiledConfig;
import java.io.File;
import java.io.Serializable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CompileFringeConfigurationTask
extends Task {
    protected File _tsetmap;
    protected File _fringedef;
    protected File _target;

    public void setTileSetMap(File tsetmap) {
        this._tsetmap = tsetmap;
    }

    public void setFringeDef(File fringedef) {
        this._fringedef = fringedef;
    }

    public void setTarget(File target) {
        this._target = target;
    }

    public void execute() throws BuildException {
        Serializable config;
        MapFileTileSetIDBroker broker;
        if (!this._fringedef.exists()) {
            throw new BuildException("Fringe definition file not found [path=" + this._fringedef.getPath() + "].");
        }
        try {
            broker = new MapFileTileSetIDBroker(this._tsetmap);
        }
        catch (PersistenceException pe) {
            throw new BuildException("Couldn't set up tileset mapping [path=" + this._tsetmap.getPath() + ", error=" + pe.getCause() + "].");
        }
        FringeConfigurationParser parser = new FringeConfigurationParser(broker);
        try {
            config = parser.parseConfig(this._fringedef);
        }
        catch (Exception e) {
            throw new BuildException("Failure parsing config definition", (Throwable)e);
        }
        try {
            CompiledConfig.saveConfig((File)this._target, (Serializable)config);
        }
        catch (Exception e) {
            throw new BuildException("Failure writing serialized config", (Throwable)e);
        }
    }
}

