/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.bundle.tools;

import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.tools.xml.SwissArmyTileSetRuleSet;
import com.threerings.media.tile.tools.xml.TileSetRuleSet;
import com.threerings.media.tile.tools.xml.UniformTileSetRuleSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.xml.sax.SAXException;

public class ComponentBundlerUtil {
    public static Map<String, TileSet> parseActionTileSets(File file) throws IOException, SAXException {
        return ComponentBundlerUtil.parseActionTileSets(new BufferedInputStream(new FileInputStream(file)));
    }

    public static Map<String, TileSet> parseActionTileSets(InputStream in) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.addSetProperties("actions/action");
        ComponentBundlerUtil.addTileSetRuleSet(digester, new SwissArmyTileSetRuleSet());
        ComponentBundlerUtil.addTileSetRuleSet(digester, new UniformTileSetRuleSet("/uniformTileset"));
        ActionMap actsets = new ActionMap();
        digester.push((Object)actsets);
        digester.parse(in);
        return actsets;
    }

    protected static void addTileSetRuleSet(Digester digester, TileSetRuleSet ruleSet) {
        ruleSet.setPrefix("actions/action");
        digester.addRuleSet((RuleSet)ruleSet);
        digester.addSetNext(ruleSet.getPath(), "addTileSet", TileSet.class.getName());
    }

    public static class ActionMap
    extends HashMap<String, TileSet> {
        protected String _name;

        public void setName(String name) {
            this._name = name;
        }

        public void addTileSet(TileSet set) {
            set.setName(this._name);
            this.put(this._name, set);
        }
    }
}

