/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile.bundle.tools;

import com.google.common.collect.Lists;
import com.samskivert.io.PersistenceException;
import com.samskivert.io.StreamUtil;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMap;
import com.threerings.media.Log;
import com.threerings.media.tile.ImageProvider;
import com.threerings.media.tile.ObjectTileSet;
import com.threerings.media.tile.SimpleCachingImageProvider;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TileSetIDBroker;
import com.threerings.media.tile.TrimmedObjectTileSet;
import com.threerings.media.tile.bundle.TileSetBundle;
import com.threerings.media.tile.tools.xml.TileSetRuleSet;
import com.threerings.resource.FastImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.imageio.ImageIO;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.xml.sax.SAXException;

public class TileSetBundler {
    protected Digester _digester;
    protected boolean _keepRawPngs;
    protected boolean _uncompressed;

    public TileSetBundler(String configPath) throws IOException {
        this(new File(configPath));
    }

    public TileSetBundler(File configFile) throws IOException {
        this(configFile, false, false);
    }

    public TileSetBundler(File configFile, boolean keepRawPngs, boolean uncompressed) throws IOException {
        this._keepRawPngs = keepRawPngs;
        this._uncompressed = uncompressed;
        Digester digester = new Digester();
        ArrayList mappings = Lists.newArrayList();
        digester.push((Object)mappings);
        digester.addObjectCreate("bundler-config/mapping", Mapping.class.getName());
        digester.addSetNext("bundler-config/mapping", "add", "java.lang.Object");
        digester.addCallMethod("bundler-config/mapping", "init", 2);
        digester.addCallParam("bundler-config/mapping/path", 0);
        digester.addCallParam("bundler-config/mapping/ruleset", 1);
        FileInputStream fin = new FileInputStream(configFile);
        try {
            digester.parse((InputStream)fin);
        }
        catch (SAXException saxe) {
            String errmsg = "Failure parsing bundler config file [file=" + configFile.getPath() + "]";
            throw (IOException)new IOException(errmsg).initCause(saxe);
        }
        fin.close();
        this._digester = new Digester();
        int msize = mappings.size();
        int ii = 0;
        while (ii < msize) {
            Mapping map = (Mapping)mappings.get(ii);
            try {
                TileSetRuleSet ruleset = (TileSetRuleSet)((Object)Class.forName(map.ruleset).newInstance());
                ruleset.setPrefix(map.path);
                this._digester.addRuleSet((RuleSet)ruleset);
                this._digester.addSetNext(ruleset.getPath(), "add", "java.lang.Object");
            }
            catch (Exception e) {
                String errmsg = "Unable to create tileset rule set instance [mapping=" + map + "].";
                throw (IOException)new IOException(errmsg).initCause(e);
            }
            ++ii;
        }
    }

    public void createBundle(TileSetIDBroker idBroker, File bundleDesc, String targetPath) throws IOException {
        this.createBundle(idBroker, bundleDesc, new File(targetPath));
    }

    public boolean createBundle(TileSetIDBroker idBroker, final File bundleDesc, File target) throws IOException {
        ArrayList sets = Lists.newArrayList();
        this._digester.push((Object)sets);
        FileInputStream fin = new FileInputStream(bundleDesc);
        try {
            try {
                this._digester.parse((InputStream)fin);
            }
            catch (SAXException saxe) {
                String errmsg = "Failure parsing bundle description file [path=" + bundleDesc.getPath() + "]";
                throw (IOException)new IOException(errmsg).initCause(saxe);
            }
        }
        finally {
            fin.close();
        }
        long newest = bundleDesc.lastModified();
        TileSetBundle bundle = new TileSetBundle();
        try {
            int ii = 0;
            while (ii < sets.size()) {
                TileSet set = (TileSet)sets.get(ii);
                String name = set.getName();
                if (name == null) {
                    Log.log.warning((Object)("Tileset was parsed, but received no name [set=" + set + "]. Skipping."), new Object[0]);
                } else {
                    File tsfile = new File(bundleDesc.getParent(), set.getImagePath());
                    if (!tsfile.exists()) {
                        System.err.println("Tile set missing image file [bundle=" + bundleDesc.getPath() + ", name=" + set.getName() + ", imgpath=" + tsfile.getPath() + "].");
                    } else {
                        if (tsfile.lastModified() > newest) {
                            newest = tsfile.lastModified();
                        }
                        try {
                            int tileSetId = idBroker.getTileSetID(name);
                            bundle.addTileSet(tileSetId, set);
                        }
                        catch (PersistenceException pe) {
                            String errmsg = "Failure obtaining a tileset id for tileset [set=" + set + "].";
                            throw (IOException)new IOException(errmsg).initCause(pe);
                        }
                    }
                }
                ++ii;
            }
            sets.clear();
        }
        finally {
            try {
                idBroker.commit();
            }
            catch (PersistenceException pe) {
                Log.log.warning((Object)("Failure committing brokered tileset ids back to broker's persistent store [error=" + (Object)((Object)pe) + "]."), new Object[0]);
            }
        }
        if (this.skipIfTargetNewer() && newest < target.lastModified()) {
            return false;
        }
        SimpleCachingImageProvider improv = new SimpleCachingImageProvider(){

            protected BufferedImage loadImage(String path) throws IOException {
                return ImageIO.read(new File(bundleDesc.getParent(), path));
            }
        };
        return this.createBundle(target, bundle, (ImageProvider)improv, bundleDesc.getParent(), newest);
    }

    public boolean createBundle(File target, TileSetBundle bundle, ImageProvider improv, String imageBase, long newestMod) throws IOException {
        return TileSetBundler.createBundleJar(target, bundle, improv, imageBase, this._keepRawPngs, this._uncompressed);
    }

    public static boolean createBundleJar(File target, TileSetBundle bundle, ImageProvider improv, String imageBase, boolean keepOriginalPngs, boolean uncompressed) throws IOException {
        FileOutputStream fout = new FileOutputStream(target);
        Manifest manifest = new Manifest();
        JarOutputStream jar = new JarOutputStream((OutputStream)fout, manifest);
        jar.setLevel(uncompressed ? 0 : 9);
        try {
            Iterator iditer = bundle.enumerateTileSetIds();
            HashIntMap toUpdate = new HashIntMap();
            while (iditer.hasNext()) {
                int tileSetId = (Integer)iditer.next();
                TileSet set = bundle.getTileSet(tileSetId);
                String imagePath = set.getImagePath();
                if (imagePath == null) {
                    Log.log.warning((Object)("Tileset contains no image path [set=" + set + "]. It ain't gonna work."), new Object[0]);
                    continue;
                }
                if (!keepOriginalPngs && set instanceof ObjectTileSet) {
                    set.setImageProvider(improv);
                    imagePath = TileSetBundler.adjustImagePath(imagePath);
                    jar.putNextEntry(new JarEntry(imagePath));
                    try {
                        TrimmedObjectTileSet tset = TrimmedObjectTileSet.trimObjectTileSet((ObjectTileSet)((ObjectTileSet)set), (OutputStream)jar);
                        tset.setImagePath(imagePath);
                        toUpdate.put(tileSetId, (Object)tset);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        String msg = "Error adding tileset to bundle " + imagePath + ", " + set.getName() + ": " + e;
                        throw (IOException)new IOException(msg).initCause(e);
                    }
                }
                File ifile = new File(imageBase, imagePath);
                try {
                    BufferedImage image = ImageIO.read(ifile);
                    if (!keepOriginalPngs && FastImageIO.canWrite((BufferedImage)image)) {
                        imagePath = TileSetBundler.adjustImagePath(imagePath);
                        jar.putNextEntry(new JarEntry(imagePath));
                        set.setImagePath(imagePath);
                        FastImageIO.write((BufferedImage)image, (OutputStream)jar);
                        continue;
                    }
                    jar.putNextEntry(new JarEntry(imagePath));
                    FileInputStream imgin = new FileInputStream(ifile);
                    StreamUtil.copy((InputStream)imgin, (OutputStream)jar);
                }
                catch (Exception e) {
                    String msg = "Failure bundling image " + ifile + ": " + e;
                    throw (IOException)new IOException(msg).initCause(e);
                }
            }
            bundle.putAll((IntMap)toUpdate);
            JarEntry entry = new JarEntry("tsbundles.dat");
            jar.putNextEntry(entry);
            ObjectOutputStream oout = new ObjectOutputStream(jar);
            oout.writeObject(bundle);
            oout.flush();
            jar.close();
            return true;
        }
        catch (Exception e) {
            jar.close();
            if (!target.delete()) {
                Log.log.warning((Object)("Failed to close botched bundle '" + target + "'."), new Object[0]);
            }
            String errmsg = "Failed to create bundle " + target + ": " + e;
            throw (IOException)new IOException(errmsg).initCause(e);
        }
    }

    protected boolean skipIfTargetNewer() {
        return true;
    }

    protected static String adjustImagePath(String imagePath) {
        int didx = imagePath.lastIndexOf(".");
        return String.valueOf(didx == -1 ? imagePath : imagePath.substring(0, didx)) + ".raw";
    }

    public static class Mapping {
        public String path;
        public String ruleset;

        public void init(String path, String ruleset) {
            this.path = path;
            this.ruleset = ruleset;
        }

        public String toString() {
            return "[path=" + this.path + ", ruleset=" + this.ruleset + "]";
        }
    }
}

