/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.bundle.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.Tuple;
import com.threerings.cast.ActionSequence;
import com.threerings.cast.ComponentClass;
import com.threerings.cast.tools.xml.ActionRuleSet;
import com.threerings.cast.tools.xml.ClassRuleSet;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.tools.xml.SwissArmyTileSetRuleSet;
import com.threerings.media.tile.tools.xml.TileSetRuleSet;
import com.threerings.media.tile.tools.xml.UniformTileSetRuleSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataBundlerTask
extends Task {
    protected String _actionDef;
    protected String _classDef;
    protected File _target;

    public void setActiondef(String actiondef) {
        this._actionDef = actiondef;
    }

    public void setClassdef(String classdef) {
        this._classDef = classdef;
    }

    public void setTarget(File target) {
        this._target = target;
    }

    public void execute() throws BuildException {
        this.ensureSet(this._actionDef, "Must specify the action sequence definitions via the 'actiondef' attribute.");
        this.ensureSet(this._classDef, "Must specify the component class definitions via the 'classdef' attribute.");
        this.ensureSet(this._target, "Must specify the path to the target bundle file via the 'target' attribute.");
        OutputStream fout = null;
        try {
            try {
                Tuple<Map<String, ActionSequence>, Map<String, TileSet>> tuple = this.parseActions();
                Map actions = (Map)tuple.left;
                Map actionSets = (Map)tuple.right;
                Map<String, ComponentClass> classes = this.parseClasses();
                fout = this.createOutputStream(this._target);
                fout = this.nextEntry(fout, "actions.dat");
                ObjectOutputStream oout = new ObjectOutputStream(fout);
                oout.writeObject(actions);
                oout.flush();
                fout = this.nextEntry(fout, "action_sets.dat");
                oout = new ObjectOutputStream(fout);
                oout.writeObject(actionSets);
                oout.flush();
                fout = this.nextEntry(fout, "classes.dat");
                oout = new ObjectOutputStream(fout);
                oout.writeObject(classes);
                oout.flush();
                fout.close();
            }
            catch (IOException ioe) {
                String errmsg = "Unable to output to target bundle [path=" + this._target.getPath() + "].";
                throw new BuildException(errmsg, (Throwable)ioe);
            }
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected OutputStream createOutputStream(File target) throws IOException {
        JarOutputStream jout = new JarOutputStream(new FileOutputStream(target));
        jout.setLevel(9);
        return jout;
    }

    protected OutputStream nextEntry(OutputStream lastEntry, String path) throws IOException {
        ((JarOutputStream)lastEntry).putNextEntry(new JarEntry(path));
        return lastEntry;
    }

    protected static void addTileSetRuleSet(Digester digester, TileSetRuleSet ruleSet) {
        ruleSet.setPrefix("actions/action");
        digester.addRuleSet((RuleSet)ruleSet);
        digester.addSetNext(ruleSet.getPath(), "add", Object.class.getName());
    }

    protected Tuple<Map<String, ActionSequence>, Map<String, TileSet>> parseActions() throws BuildException {
        Digester digester = new Digester();
        ActionRuleSet arules = new ActionRuleSet();
        arules.setPrefix("actions");
        digester.addRuleSet((RuleSet)arules);
        digester.addSetNext("actions/action", "add", Object.class.getName());
        ArrayList<?> actlist = this.parseList(digester, this._actionDef);
        digester = new Digester();
        MetadataBundlerTask.addTileSetRuleSet(digester, new SwissArmyTileSetRuleSet());
        MetadataBundlerTask.addTileSetRuleSet(digester, new UniformTileSetRuleSet("/uniformTileset"));
        ArrayList<?> setlist = this.parseList(digester, this._actionDef);
        if (actlist.size() != setlist.size()) {
            String errmsg = "An action is missing its tileset definition, or something even wackier is going on.";
            throw new BuildException(errmsg);
        }
        HashMap actmap = Maps.newHashMap();
        HashMap setmap = Maps.newHashMap();
        int ii = 0;
        while (ii < setlist.size()) {
            TileSet set = (TileSet)setlist.get(ii);
            ActionSequence act = (ActionSequence)actlist.get(ii);
            String errmsg = ActionRuleSet.validate(act);
            if (errmsg != null) {
                errmsg = "Action sequence invalid [seq=" + act + ", error=" + errmsg + "].";
                throw new BuildException(errmsg);
            }
            actmap.put(act.name, act);
            setmap.put(act.name, set);
            ++ii;
        }
        return new Tuple((Object)actmap, (Object)setmap);
    }

    protected Map<String, ComponentClass> parseClasses() throws BuildException {
        Digester digester = new Digester();
        ClassRuleSet crules = new ClassRuleSet();
        crules.setPrefix("classes");
        digester.addRuleSet((RuleSet)crules);
        digester.addSetNext("classes/class", "add", Object.class.getName());
        ArrayList<?> setlist = this.parseList(digester, this._classDef);
        HashMap clmap = Maps.newHashMap();
        int ii = 0;
        while (ii < setlist.size()) {
            ComponentClass cl = (ComponentClass)setlist.get(ii);
            clmap.put(cl.name, cl);
            ++ii;
        }
        return clmap;
    }

    protected ArrayList<?> parseList(Digester digester, String path) throws BuildException {
        try {
            FileInputStream fin = new FileInputStream(path);
            BufferedInputStream bin = new BufferedInputStream(fin);
            ArrayList setlist = Lists.newArrayList();
            digester.push((Object)setlist);
            try {
                digester.parse((InputStream)bin);
            }
            catch (Exception e) {
                throw new BuildException("Parsing error.", (Throwable)e);
            }
            return setlist;
        }
        catch (FileNotFoundException fnfe) {
            String errmsg = "Unable to load metadata definition file [path=" + path + "].";
            throw new BuildException(errmsg, (Throwable)fnfe);
        }
    }

    protected void ensureSet(Object value, String errmsg) throws BuildException {
        if (value == null) {
            throw new BuildException(errmsg);
        }
    }
}

