/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile.bundle.tools;

import com.google.common.collect.Lists;
import com.threerings.media.tile.TileSetIDBroker;
import com.threerings.media.tile.bundle.tools.TileSetBundler;
import com.threerings.media.tile.tools.MapFileTileSetIDBroker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class TileSetBundlerTask
extends Task {
    protected File _config;
    protected File _mapfile;
    protected ArrayList<FileSet> _filesets = Lists.newArrayList();
    protected boolean _keepRawPngs;
    protected boolean _uncompressed;

    public void setConfig(File config) {
        this._config = config;
    }

    public void setMapfile(File mapfile) {
        this._mapfile = mapfile;
    }

    public void addFileset(FileSet set) {
        this._filesets.add(set);
    }

    public void setKeepRawPngs(boolean keep) {
        this._keepRawPngs = keep;
    }

    public void setUncompressed(boolean uncompressed) {
        this._uncompressed = uncompressed;
    }

    public void execute() throws BuildException {
        this.ensureSet(this._config, "Must specify the path to the bundler config file via the 'config' attribute.");
        this.ensureSet(this._mapfile, "Must specify the path to the tileset id map file via the 'mapfile' attribute.");
        File cfile = null;
        try {
            TileSetBundler bundler = this.createBundler();
            MapFileTileSetIDBroker broker = new MapFileTileSetIDBroker(this._mapfile);
            for (int ii = 0; ii < this._filesets.size(); ++ii) {
                String[] srcFiles;
                FileSet fs = this._filesets.get(ii);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File fromDir = fs.getDir(this.getProject());
                for (String srcFile : srcFiles = ds.getIncludedFiles()) {
                    cfile = new File(fromDir, srcFile);
                    String cpath = cfile.getPath();
                    if (!cpath.endsWith(".xml")) {
                        System.err.println("Can't infer bundle name from bundle config name [path=" + cpath + "].\n" + "Config file should end with .xml.");
                        continue;
                    }
                    String bpath = this.getTargetPath(fromDir, cpath);
                    File bfile = new File(bpath);
                    if (bundler.createBundle((TileSetIDBroker)broker, cfile, bfile)) {
                        System.out.println("Created bundle from '" + cpath + "'...");
                        continue;
                    }
                    System.out.println("Tileset bundle up to date '" + bpath + "'.");
                }
            }
            broker.commit();
        }
        catch (Exception e) {
            String errmsg = "Failure creating tileset bundle [source=" + cfile + "]: " + e.getMessage();
            throw new BuildException(errmsg, (Throwable)e);
        }
    }

    protected TileSetBundler createBundler() throws IOException {
        return new TileSetBundler(this._config, this._keepRawPngs, this._uncompressed);
    }

    protected String getTargetPath(File fromDir, String path) {
        return path.substring(0, path.length() - 4) + ".jar";
    }

    protected void ensureSet(Object value, String errmsg) throws BuildException {
        if (value == null) {
            throw new BuildException(errmsg);
        }
    }
}

