/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.IntResultListener;
import com.samskivert.util.Invoker;
import com.samskivert.util.Logger;
import com.samskivert.util.ResultListener;
import com.threerings.NaryaLog;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.InvocationException;

public class Resulting<T>
extends Invoker.Unit
implements ResultListener<T>,
InvocationService.ConfirmListener,
InvocationService.ResultListener {
    public static final Function<Object, Void> TO_VOID = new Function<Object, Void>(){

        public Void apply(Object o) {
            return null;
        }
    };
    protected InvocationService.InvocationListener _invChain;
    protected ResultListener<T> _chain;
    protected Logger _log;
    protected Object[] _logArgs;
    protected T _result;
    protected Exception _error;
    protected static final ThreadLocal<StopException> STOP = new ThreadLocal<StopException>(){

        @Override
        protected StopException initialValue() {
            return new StopException();
        }
    };

    public Resulting(String name) {
        super(name);
    }

    public Resulting(String name, Resulting<T> chain) {
        this(name, (ResultListener<T>)chain);
    }

    public Resulting(Resulting<T> chain) {
        this(chain.toString(), chain);
    }

    public Resulting(String name, ResultListener<T> chain) {
        this(name);
        this._chain = chain;
    }

    public Resulting(ResultListener<T> chain) {
        this(chain.toString(), chain);
    }

    public Resulting(String name, InvocationService.InvocationListener chain) {
        this(name);
        this._invChain = chain;
    }

    public Resulting(InvocationService.InvocationListener chain) {
        this(chain.toString(), chain);
    }

    public <Q> Resulting(String name, final ResultListener<Q> chain, final Function<? super T, ? extends Q> xform) {
        this(name, new ResultListener<T>(){

            public void requestCompleted(T result) {
                chain.requestCompleted(xform.apply(result));
            }

            public void requestFailed(Exception cause) {
                chain.requestFailed(cause);
            }
        });
    }

    public <Q> Resulting(ResultListener<Q> chain, Function<? super T, ? extends Q> xform) {
        this(chain.toString(), chain, xform);
    }

    public Resulting(String name, Logger log, Object ... logArgs) {
        this(name);
        this._log = log;
        this._logArgs = logArgs;
    }

    public final IntResultListener asIntResultListener() {
        return new IntResultListener(){

            public void requestCompleted(int result) {
                Resulting.this.requestProcessed((Object)result);
            }

            public void requestFailed(Exception cause) {
                Resulting.this.requestFailed(cause);
            }
        };
    }

    public T invokePersist() throws Exception {
        return null;
    }

    public final boolean invoke() {
        try {
            this._result = this.invokePersist();
        }
        catch (StopException se) {
            return false;
        }
        catch (Exception e) {
            this._error = e;
        }
        return true;
    }

    protected final T stop() throws StopException {
        throw STOP.get();
    }

    public final void handleResult() {
        if (this._error != null) {
            this.requestFailed(this._error);
        } else {
            this.requestCompleted(this._result);
        }
    }

    @Override
    public final void requestFailed(String error) {
        this.requestFailed(new InvocationException(error));
    }

    @Override
    public final void requestProcessed() {
        this.requestCompleted(null);
    }

    public final void requestProcessed(Object result) {
        Object casted = result;
        this.requestCompleted(casted);
    }

    public void requestFailed(Exception cause) {
        if (this._chain != null) {
            this._chain.requestFailed(cause);
        } else if (this._invChain != null) {
            this._invChain.requestFailed(cause instanceof InvocationException ? cause.getMessage() : "m.internal_error");
        } else {
            Object[] args;
            Object[] logArgs = (Object[])Objects.firstNonNull((Object)this._logArgs, (Object)ArrayUtil.EMPTY_OBJECT);
            if (cause instanceof InvocationException) {
                args = new Object[logArgs.length + 4];
                args[args.length - 2] = "error";
                args[args.length - 1] = cause.getMessage();
            } else {
                args = new Object[logArgs.length + 3];
                args[args.length - 1] = cause;
            }
            args[0] = "Resulting";
            args[1] = this;
            System.arraycopy(logArgs, 0, args, 2, logArgs.length);
            ((Logger)Objects.firstNonNull((Object)this._log, (Object)NaryaLog.log)).warning((Object)"Request failed", args);
        }
    }

    public void requestCompleted(T result) {
        if (this._chain != null) {
            this._chain.requestCompleted(result);
        } else if (this._invChain instanceof InvocationService.ResultListener) {
            ((InvocationService.ResultListener)this._invChain).requestProcessed(result);
        } else if (this._invChain instanceof InvocationService.ConfirmListener) {
            ((InvocationService.ConfirmListener)this._invChain).requestProcessed();
        }
    }

    protected static class StopException
    extends RuntimeException {
        protected StopException() {
        }
    }
}

