/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.protobuf.io;

import com.google.common.base.Defaults;
import com.samskivert.util.ArrayUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ConstructorHelper {
    protected Class<?> _target;
    protected Constructor<?> _ctor;
    protected Object[] _ctorArgs;

    protected ConstructorHelper(Class<?> target) {
        this._target = target;
        this.initConstructor();
    }

    public <T> T createObject() throws IOException, ClassNotFoundException {
        try {
            return (T)this._ctor.newInstance(this._ctorArgs);
        }
        catch (InvocationTargetException ite) {
            String errmsg = "Error instantiating object [type=" + this._target.getName() + "]";
            throw (IOException)new IOException(errmsg).initCause(ite.getCause());
        }
        catch (InstantiationException ie) {
            String errmsg = "Error instantiating object [type=" + this._target.getName() + "]";
            throw (IOException)new IOException(errmsg).initCause(ie);
        }
        catch (IllegalAccessException iae) {
            String errmsg = "Error instantiating object [type=" + this._target.getName() + "]";
            throw (IOException)new IOException(errmsg).initCause(iae);
        }
    }

    protected void initConstructor() {
        Constructor<?>[] constructorArray = this._target.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> ctor = constructorArray[n2];
            if (ctor.getParameterTypes().length == 0) {
                this._ctor = ctor;
                this._ctorArgs = ArrayUtil.EMPTY_OBJECT;
                return;
            }
            ++n2;
        }
        Constructor<?>[] ctors = this._target.getDeclaredConstructors();
        if (ctors.length > 1) {
            throw new RuntimeException("Streamable closure classes must have either a zero-argument constructor or a single argument-taking constructor; multiple argument-taking constructors are not allowed [class=" + this._target.getName() + "]");
        }
        this._ctor = ctors[0];
        this._ctor.setAccessible(true);
        Class<?>[] ptypes = this._ctor.getParameterTypes();
        this._ctorArgs = new Object[ptypes.length];
        int ii = 0;
        while (ii < ptypes.length) {
            this._ctorArgs[ii] = Defaults.defaultValue(ptypes[ii]);
            ++ii;
        }
    }
}

