/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server.net;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.util.Invoker;
import com.samskivert.util.Lifecycle;
import com.samskivert.util.Queue;
import com.samskivert.util.ResultListener;
import com.samskivert.util.Tuple;
import com.threerings.io.ByteBufferInputStream;
import com.threerings.io.FramingOutputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.UnreliableObjectInputStream;
import com.threerings.io.UnreliableObjectOutputStream;
import com.threerings.nio.conman.Connection;
import com.threerings.nio.conman.ConnectionManager;
import com.threerings.nio.conman.NetEventHandler;
import com.threerings.presents.Log;
import com.threerings.presents.annotation.AuthInvoker;
import com.threerings.presents.data.PresentsConMgrStats;
import com.threerings.presents.net.Credentials;
import com.threerings.presents.net.Message;
import com.threerings.presents.net.PongResponse;
import com.threerings.presents.net.Transport;
import com.threerings.presents.server.Authenticator;
import com.threerings.presents.server.ChainedAuthenticator;
import com.threerings.presents.server.ClientManager;
import com.threerings.presents.server.DummyAuthenticator;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.presents.server.ReportManager;
import com.threerings.presents.server.net.AuthingConnection;
import com.threerings.presents.server.net.PresentsConnection;
import com.threerings.presents.util.DatagramSequencer;
import com.threerings.presents.util.SecureUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.security.PrivateKey;
import java.util.List;

@Singleton
public class PresentsConnectionManager
extends ConnectionManager
implements ReportManager.Reporter {
    @Inject(optional=true)
    protected Authenticator _author = new DummyAuthenticator();
    protected List<ChainedAuthenticator> _authors = Lists.newArrayList();
    protected PrivateKey _privateKey;
    protected Queue<AuthingConnection> _authq = Queue.newQueue();
    protected Queue<Tuple<Connection, InetSocketAddress>> _connectq = Queue.newQueue();
    protected Queue<OutgoingConnectionHandler> _outfailq = Queue.newQueue();
    protected FramingOutputStream _framer = new FramingOutputStream();
    protected ByteArrayOutputStream _flattener = new ByteArrayOutputStream();
    @Inject
    @AuthInvoker
    protected Invoker _authInvoker;
    @Inject
    protected ClientManager _clmgr;
    @Inject
    protected PresentsDObjectMgr _omgr;
    protected PresentsConMgrStats _lastStats = new PresentsConMgrStats();
    protected Queue<Tuple<PresentsConnection, byte[]>> _dataq = Queue.newQueue();
    protected ByteBuffer _databuf = ByteBuffer.allocateDirect(1450);

    @Inject
    public PresentsConnectionManager(Lifecycle cycle, ReportManager repmgr) throws IOException {
        super(cycle, 90000L);
        repmgr.registerReporter(this);
        this._stats = new PresentsConMgrStats();
    }

    @Override
    public synchronized PresentsConMgrStats getStats() {
        ((PresentsConMgrStats)this._stats).authQueueSize = this._authq.size();
        return (PresentsConMgrStats)super.getStats();
    }

    @Override
    public void appendReport(StringBuilder report, long now, long sinceLast, boolean reset) {
        PresentsConMgrStats stats = this.getStats();
        long eventCount = stats.eventCount - this._lastStats.eventCount;
        int connects = stats.connects - this._lastStats.connects;
        int disconnects = stats.disconnects - this._lastStats.disconnects;
        int closes = stats.closes - this._lastStats.closes;
        long bytesIn = stats.bytesIn - this._lastStats.bytesIn;
        long bytesOut = stats.bytesOut - this._lastStats.bytesOut;
        long msgsIn = stats.msgsIn - this._lastStats.msgsIn;
        long msgsOut = stats.msgsOut - this._lastStats.msgsOut;
        if (reset) {
            this._lastStats = stats;
        }
        sinceLast = Math.max(sinceLast, 1L);
        report.append("* presents.net.ConnectionManager:\n");
        report.append("- Network connections: ");
        report.append(stats.connectionCount).append(" connections, ");
        report.append(stats.handlerCount).append(" handlers\n");
        report.append("- Network activity: ");
        report.append(eventCount).append(" events, ");
        report.append(connects).append(" connects, ");
        report.append(disconnects).append(" disconnects, ");
        report.append(closes).append(" closes\n");
        report.append("- Network input: ");
        report.append(bytesIn).append(" bytes, ");
        report.append(msgsIn).append(" msgs, ");
        report.append(msgsIn * 1000L / sinceLast).append(" mps, ");
        long avgIn = msgsIn == 0L ? 0L : bytesIn / msgsIn;
        report.append(avgIn).append(" avg size, ");
        report.append(bytesIn * 1000L / sinceLast).append(" bps\n");
        report.append("- Network output: ");
        report.append(bytesOut).append(" bytes, ");
        report.append(msgsOut).append(" msgs, ");
        report.append(msgsOut * 1000L / sinceLast).append(" mps, ");
        long avgOut = msgsOut == 0L ? 0L : bytesOut / msgsOut;
        report.append(avgOut).append(" avg size, ");
        report.append(bytesOut * 1000L / sinceLast).append(" bps\n");
    }

    public void addChainedAuthenticator(ChainedAuthenticator author) {
        this._authors.add(author);
    }

    public boolean setPrivateKey(PrivateKey key) {
        if (SecureUtil.ciphersSupported(key)) {
            this._privateKey = key;
            return true;
        }
        return false;
    }

    public boolean setPrivateKey(String key) {
        return key == null ? false : this.setPrivateKey(SecureUtil.stringToRSAPrivateKey(key));
    }

    public PrivateKey getPrivateKey() {
        return this._privateKey;
    }

    protected int handleDatagram(DatagramChannel listener, long when) {
        InetSocketAddress source;
        this._databuf.clear();
        try {
            source = (InetSocketAddress)listener.receive(this._databuf);
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Failure receiving datagram.", new Object[]{ioe});
            return 0;
        }
        if (source == null) {
            Log.log.info((Object)"Psych! Got READ_READY, but no datagram.", new Object[0]);
            return 0;
        }
        int size = this._databuf.flip().remaining();
        if (size < 14) {
            Log.log.warning((Object)"Received undersized datagram", new Object[]{"source", source, "size", size});
            return 0;
        }
        int connectionId = this._databuf.getInt();
        Connection conn = (Connection)this._connections.get(connectionId);
        if (conn != null) {
            ((PresentsConnection)conn).handleDatagram(source, listener, this._databuf, when);
        } else {
            Log.log.debug((Object)"Received datagram for unknown connection", new Object[]{"id", connectionId, "source", source});
        }
        return size;
    }

    protected void postMessage(PresentsConnection conn, Message msg) {
        if (!this.isRunning()) {
            Log.log.warning((Object)"Posting message to inactive connection manager", new Object[]{"msg", msg, new Exception()});
        }
        if (conn == null || msg == null) {
            Log.log.warning((Object)"postMessage() bogosity", new Object[]{"conn", conn, "msg", msg, new Exception()});
            return;
        }
        if (!this._omgr.isDispatchThread()) {
            Log.log.warning((Object)"Message posted on non-distributed object thread", new Object[]{"conn", conn, "msg", msg, "thread", Thread.currentThread(), new Exception()});
        }
        try {
            if (!msg.getTransport().isReliable() && (conn.getTransmitDatagrams() || msg instanceof PongResponse) && this.postDatagram(conn, msg)) {
                return;
            }
            msg.noteActualTransport(Transport.RELIABLE_ORDERED);
            this._framer.resetFrame();
            ObjectOutputStream oout = conn.getObjectOutputStream(this._framer);
            oout.writeObject(msg);
            oout.flush();
            ByteBuffer buffer = this._framer.frameAndReturnBuffer();
            byte[] data = new byte[buffer.limit()];
            buffer.get(data);
            this._outq.append((Object)Tuple.newTuple((Object)conn, (Object)data));
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failure flattening message", new Object[]{"conn", conn, "msg", msg, e});
        }
    }

    protected boolean postDatagram(PresentsConnection conn, Message msg) throws Exception {
        this._flattener.reset();
        DatagramSequencer sequencer = conn.getDatagramSequencer();
        sequencer.writeDatagram(msg);
        if (this._flattener.size() > 1450) {
            return false;
        }
        msg.noteActualTransport(Transport.UNRELIABLE_UNORDERED);
        byte[] data = this._flattener.toByteArray();
        this._dataq.append((Object)Tuple.newTuple((Object)conn, (Object)data));
        return true;
    }

    protected DatagramSequencer createDatagramSequencer() {
        return new DatagramSequencer(new UnreliableObjectInputStream(new ByteBufferInputStream(this._databuf)), new UnreliableObjectOutputStream(this._flattener));
    }

    public void openOutgoingConnection(Connection conn, String hostname, int port) throws IOException {
        SocketChannel sockchan = SocketChannel.open();
        sockchan.configureBlocking(false);
        conn.init(this, sockchan, System.currentTimeMillis());
        this._connectq.append((Object)Tuple.newTuple((Object)conn, (Object)new InetSocketAddress(hostname, port)));
    }

    protected void startOutgoingConnection(Connection conn, InetSocketAddress addr) {
        SocketChannel sockchan = conn.getChannel();
        try {
            conn.selkey = sockchan.register(this._selector, 8);
            NetEventHandler handler = sockchan.connect(addr) ? conn : new OutgoingConnectionHandler(conn);
            this._handlers.put(conn.selkey, handler);
        }
        catch (IOException ioe) {
            Log.log.warning((Object)("Failed to initiate connection for " + sockchan + "."), new Object[]{ioe});
            conn.connectFailure(ioe);
        }
    }

    @Override
    protected void iterate() {
        OutgoingConnectionHandler handler;
        super.iterate();
        while ((handler = (OutgoingConnectionHandler)this._outfailq.getNonBlocking()) != null) {
            handler.handleError(new IOException("Pending connection became idle."));
        }
    }

    public boolean isRunning() {
        return super.isRunning() || this._omgr.isRunning();
    }

    @Override
    protected void handleIncoming(long iterStamp) {
        Tuple pconn;
        super.handleIncoming(iterStamp);
        while ((pconn = (Tuple)this._connectq.getNonBlocking()) != null) {
            this.startOutgoingConnection((Connection)pconn.left, (InetSocketAddress)pconn.right);
        }
        this.processAuthedConnections(iterStamp);
    }

    @Override
    protected void connectionFailed(Connection conn, IOException ioe) {
        super.connectionFailed(conn, ioe);
        this._clmgr.connectionFailed(conn, ioe);
    }

    @Override
    protected void connectionClosed(Connection conn) {
        super.connectionClosed(conn);
        this._clmgr.connectionClosed(conn);
    }

    protected void authenticateConnection(AuthingConnection conn) {
        Authenticator author = this._author;
        for (ChainedAuthenticator cauthor : this._authors) {
            if (!cauthor.shouldHandleConnection(conn)) continue;
            author = cauthor;
            break;
        }
        author.authenticateConnection(this._authInvoker, conn, new ResultListener<AuthingConnection>(){

            public void requestCompleted(AuthingConnection conn) {
                PresentsConnectionManager.this._authq.append((Object)conn);
            }

            public void requestFailed(Exception cause) {
            }
        });
    }

    @Override
    protected void handleAcceptedSocket(SocketChannel channel) {
        this.handleAcceptedSocket(channel, new AuthingConnection());
    }

    protected void processAuthedConnections(long iterStamp) {
        AuthingConnection conn;
        while ((conn = (AuthingConnection)this._authq.getNonBlocking()) != null) {
            try {
                Credentials creds = conn._authreq.getCredentials();
                PresentsConnection rconn = new PresentsConnection();
                rconn.init(this, conn.getChannel(), iterStamp);
                rconn.selkey = conn.selkey;
                rconn.inheritStreams(conn);
                this._handlers.put(rconn.selkey, rconn);
                this._connections.put(rconn.getConnectionId(), (Object)rconn);
                rconn.setDatagramSecret(conn.getAuthRequest().getCredentials().getDatagramSecret());
                ConnectionManager.OverflowQueue oflowHandler = (ConnectionManager.OverflowQueue)this._oflowqs.remove(conn);
                if (oflowHandler != null) {
                    this._oflowqs.put(rconn, oflowHandler);
                }
                this._clmgr.connectionEstablished(rconn, conn.getAuthName(), conn.getAuthRequest(), conn.getAuthResponse());
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Failure upgrading authing connection to running.", new Object[]{ioe});
            }
        }
    }

    @Override
    protected void sendOutgoingMessages(long iterStamp) {
        Tuple tup;
        super.sendOutgoingMessages(iterStamp);
        while ((tup = (Tuple)this._dataq.getNonBlocking()) != null) {
            this.writeDatagram((PresentsConnection)tup.left, (byte[])tup.right);
        }
    }

    protected boolean writeDatagram(PresentsConnection conn, byte[] data) {
        InetSocketAddress target = conn.getDatagramAddress();
        if (target == null) {
            Log.log.warning((Object)"No address to send datagram", new Object[]{"conn", conn});
            return false;
        }
        this._databuf.clear();
        this._databuf.put(data).flip();
        try {
            return conn.getDatagramChannel().send(this._databuf, target) > 0;
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Failed to send datagram.", new Object[]{ioe});
            return false;
        }
    }

    protected class OutgoingConnectionHandler
    implements NetEventHandler {
        protected final Connection _conn;

        public OutgoingConnectionHandler(Connection conn) {
            this._conn = conn;
        }

        @Override
        public int handleEvent(long when) {
            SocketChannel sockchan = this._conn.getChannel();
            try {
                if (sockchan.finishConnect()) {
                    this._conn.selkey = sockchan.register(PresentsConnectionManager.this._selector, 1);
                    PresentsConnectionManager.this._handlers.put(this._conn.selkey, this._conn);
                    Log.log.info((Object)"Outgoing connection ready", new Object[]{"conn", this._conn});
                }
            }
            catch (IOException ioe) {
                this.handleError(ioe);
            }
            return 0;
        }

        @Override
        public boolean checkIdle(long idleStamp) {
            return this._conn.checkIdle(idleStamp);
        }

        @Override
        public void becameIdle() {
            PresentsConnectionManager.this._outfailq.append((Object)this);
        }

        protected void handleError(IOException ioe) {
            PresentsConnectionManager.this._handlers.remove(this._conn.selkey);
            PresentsConnectionManager.this._oflowqs.remove(this._conn);
            this._conn.connectFailure(ioe);
        }
    }
}

