/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.threerings.presents.net.AuthRequest;
import com.threerings.presents.net.Credentials;
import com.threerings.presents.server.ClientResolver;
import com.threerings.presents.server.PresentsSession;
import com.threerings.util.Name;

public abstract class SessionFactory {
    public static SessionFactory DEFAULT = new SessionFactory(){

        @Override
        public Class<? extends PresentsSession> getSessionClass(AuthRequest areq) {
            return PresentsSession.class;
        }

        @Override
        public Class<? extends PresentsSession> getSessionClass(Name username) {
            return PresentsSession.class;
        }

        @Override
        public Class<? extends ClientResolver> getClientResolverClass(Name username) {
            return ClientResolver.class;
        }
    };

    public static SessionFactory newSessionFactory(final Class<? extends Credentials> credsClass, final Class<? extends PresentsSession> sessionClass, final Class<? extends Name> nameClass, final Class<? extends ClientResolver> resolverClass) {
        return new SessionFactory(){

            @Override
            public Class<? extends PresentsSession> getSessionClass(AuthRequest areq) {
                return credsClass.isInstance(areq.getCredentials()) ? sessionClass : null;
            }

            @Override
            public Class<? extends PresentsSession> getSessionClass(Name username) {
                return nameClass.isInstance(username) ? sessionClass : null;
            }

            @Override
            public Class<? extends ClientResolver> getClientResolverClass(Name username) {
                return nameClass.isInstance(username) ? resolverClass : null;
            }
        };
    }

    public abstract Class<? extends PresentsSession> getSessionClass(AuthRequest var1);

    public abstract Class<? extends PresentsSession> getSessionClass(Name var1);

    public abstract Class<? extends ClientResolver> getClientResolverClass(Name var1);
}

