/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.net;

import com.hexnova.narya.net.PongResponse;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.presents.Log;
import com.threerings.presents.net.DownstreamMessage;
import com.threerings.presents.net.Transport;
import com.threerings.protobuf.io.ProtobufProvider;
import java.io.IOException;

public class PongResponse
extends DownstreamMessage
implements ProtobufProvider<com.hexnova.narya.net.PongResponse> {
    protected transient long _pingStamp;
    protected long _packStamp;
    protected int _processDelay;
    protected transient long _unpackStamp;
    protected transient Transport _transport = Transport.DEFAULT;
    private transient PongResponse.Builder builder = null;

    public PongResponse() {
    }

    public PongResponse(long pingStamp, Transport transport) {
        this._pingStamp = pingStamp;
        this._transport = transport;
    }

    public long getPackStamp() {
        return this._packStamp;
    }

    public int getProcessDelay() {
        return this._processDelay;
    }

    public long getUnpackStamp() {
        return this._unpackStamp;
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        this._packStamp = System.currentTimeMillis();
        if (this._pingStamp == 0L) {
            Log.log.warning((Object)"Pong response written that was not constructed with a valid ping stamp", new Object[]{"rsp", this});
            this._processDelay = 0;
        } else {
            this._processDelay = (int)(this._packStamp - this._pingStamp);
        }
        out.defaultWriteObject();
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._unpackStamp = System.currentTimeMillis();
        in.defaultReadObject();
    }

    @Override
    public void setTransport(Transport transport) {
        this._transport = transport;
    }

    @Override
    public Transport getTransport() {
        return this._transport;
    }

    @Override
    public String toString() {
        return "[type=PONG, msgid=" + this.messageId + ", transport=" + this._transport + "]";
    }

    @Override
    public void populate(com.hexnova.narya.net.PongResponse message) throws IOException {
        this.messageId = (short)message.getMessageId();
        this._packStamp = message.getPackStamp();
        this._processDelay = message.getProcessDelay();
    }

    @Override
    public com.hexnova.narya.net.PongResponse transform() throws IOException {
        PongResponse.Builder builder = this.getBuilder();
        builder.setMessageId((int)this.messageId);
        builder.setPackStamp(this._packStamp);
        builder.setProcessDelay(this._processDelay);
        return builder.build();
    }

    public PongResponse.Builder getBuilder() {
        if (this.builder == null) {
            this.builder = com.hexnova.narya.net.PongResponse.newBuilder();
        }
        return this.builder;
    }
}

