/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.net;

import com.hexnova.narya.net.AuthRequest;
import com.threerings.io.ObjectInputStream;
import com.threerings.presents.annotation.Transient;
import com.threerings.presents.net.Credentials;
import com.threerings.presents.net.UpstreamMessage;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.protobuf.io.ProtobufRegistry;
import java.io.IOException;
import java.util.TimeZone;

public class AuthRequest
extends UpstreamMessage
implements ProtobufProvider<com.hexnova.narya.net.AuthRequest> {
    protected Credentials _creds;
    protected String _version;
    protected String _zone;
    protected String[] _bootGroups;
    @Transient
    protected AuthRequest.Builder _builder;

    public AuthRequest() {
    }

    public AuthRequest(Credentials creds, String version, String[] bootGroups) {
        this._creds = creds;
        this._version = version;
        this._zone = TimeZone.getDefault().getID();
        this._bootGroups = bootGroups;
    }

    public Credentials getCredentials() {
        return this._creds;
    }

    public String getVersion() {
        return this._version;
    }

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this._zone);
    }

    public String[] getBootGroups() {
        return this._bootGroups;
    }

    public byte[] getSecret() {
        return null;
    }

    @Override
    public String toString() {
        return "[type=AREQ, msgid=" + this.messageId + ", creds=" + this._creds + ", version=" + this._version + "]";
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public AuthRequest.Builder getBuilder() {
        if (this._builder == null) {
            this._builder = com.hexnova.narya.net.AuthRequest.newBuilder();
        } else {
            this._builder.clear();
        }
        return this._builder;
    }

    @Override
    public void populate(com.hexnova.narya.net.AuthRequest req) throws IOException {
        this.messageId = (short)req.getMessageId();
        this._version = req.getVersion();
        this._zone = req.getZone();
        this._creds = (Credentials)ProtobufRegistry.fromAnyMessage(req.getCreds());
        this._bootGroups = (String[])req.getBootGroupsList().toArray((Object[])new String[req.getBootGroupsList().size()]);
    }

    @Override
    public com.hexnova.narya.net.AuthRequest transform() throws IOException {
        AuthRequest.Builder builder = this.getBuilder();
        if (this._bootGroups != null && this._bootGroups.length > 0) {
            int i = 0;
            while (i < this._bootGroups.length) {
                builder.addBootGroups(this._bootGroups[i]);
                ++i;
            }
        }
        builder.setMessageId((int)this.messageId);
        builder.setVersion(this._version);
        builder.setZone(this._zone);
        builder.setCreds(ProtobufRegistry.toAnyMessage(this._creds));
        return builder.build();
    }
}

