/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.hexnova.narya.event.data.ObjectRemovedEvent;
import com.threerings.presents.annotation.Transient;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.NamedEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.OidList;
import com.threerings.presents.dobj.OidListListener;
import com.threerings.protobuf.io.ProtobufProvider;
import java.io.IOException;

public class ObjectRemovedEvent
extends NamedEvent
implements ProtobufProvider<com.hexnova.narya.event.data.ObjectRemovedEvent> {
    protected int _oid;
    protected transient boolean _alreadyApplied;
    @Transient
    private ObjectRemovedEvent.Builder builder = null;

    public ObjectRemovedEvent(int targetOid, String name, int oid) {
        super(targetOid, name);
        this._oid = oid;
    }

    public int getOid() {
        return this._oid;
    }

    @Override
    public boolean alreadyApplied() {
        return this._alreadyApplied;
    }

    @Override
    public boolean applyToObject(DObject target) throws ObjectAccessException {
        if (!this._alreadyApplied) {
            OidList list = (OidList)target.getAttribute(this._name);
            list.remove(this._oid);
        }
        return true;
    }

    @Override
    protected void notifyListener(Object listener) {
        if (listener instanceof OidListListener) {
            ((OidListListener)listener).objectRemoved(this);
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        buf.append("OBJREM:");
        super.toString(buf);
        buf.append(", oid=").append(this._oid);
    }

    protected ObjectRemovedEvent setAlreadyApplied(boolean alreadyApplied) {
        this._alreadyApplied = alreadyApplied;
        return this;
    }

    public ObjectRemovedEvent.Builder getBuilder() {
        if (this.builder == null) {
            this.builder = com.hexnova.narya.event.data.ObjectRemovedEvent.newBuilder();
        } else {
            this.builder.clear();
        }
        return this.builder;
    }

    @Override
    public void populate(com.hexnova.narya.event.data.ObjectRemovedEvent message) throws IOException {
        this._toid = message.getToid();
        this._name = message.getName();
    }

    @Override
    public com.hexnova.narya.event.data.ObjectRemovedEvent transform() throws IOException {
        ObjectRemovedEvent.Builder builder = this.getBuilder();
        builder.setToid(this._toid);
        builder.setName(this._name);
        return builder.build();
    }
}

