/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.hexnova.narya.event.data.ObjectAddedEvent;
import com.threerings.presents.annotation.Transient;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.NamedEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.OidList;
import com.threerings.presents.dobj.OidListListener;
import com.threerings.protobuf.io.ProtobufProvider;
import java.io.IOException;

public class ObjectAddedEvent
extends NamedEvent
implements ProtobufProvider<com.hexnova.narya.event.data.ObjectAddedEvent> {
    protected int _oid;
    protected transient boolean _alreadyApplied;
    @Transient
    private ObjectAddedEvent.Builder builder = null;

    public ObjectAddedEvent(int targetOid, String name, int oid) {
        super(targetOid, name);
        this._oid = oid;
    }

    public int getOid() {
        return this._oid;
    }

    @Override
    public boolean alreadyApplied() {
        return this._alreadyApplied;
    }

    @Override
    public boolean applyToObject(DObject target) throws ObjectAccessException {
        if (!this._alreadyApplied) {
            OidList list = (OidList)target.getAttribute(this._name);
            list.add(this._oid);
        }
        return true;
    }

    @Override
    protected void notifyListener(Object listener) {
        if (listener instanceof OidListListener) {
            ((OidListListener)listener).objectAdded(this);
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        buf.append("OBJADD:");
        super.toString(buf);
        buf.append(", oid=").append(this._oid);
    }

    protected ObjectAddedEvent setAlreadyApplied(boolean alreadyApplied) {
        this._alreadyApplied = alreadyApplied;
        return this;
    }

    public ObjectAddedEvent.Builder getBuilder() {
        if (this.builder == null) {
            this.builder = com.hexnova.narya.event.data.ObjectAddedEvent.newBuilder();
        }
        return this.builder;
    }

    @Override
    public void populate(com.hexnova.narya.event.data.ObjectAddedEvent message) throws IOException {
        this._toid = message.getToid();
        this._name = message.getName();
        this._oid = message.getOid();
    }

    @Override
    public com.hexnova.narya.event.data.ObjectAddedEvent transform() throws IOException {
        ObjectAddedEvent.Builder builder = this.getBuilder();
        builder.setToid(this._toid);
        builder.setName(this._name);
        builder.setOid(this._oid);
        return builder.build();
    }
}

