/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.hexnova.narya.event.data.EntryUpdatedEvent;
import com.samskivert.util.StringUtil;
import com.threerings.presents.Log;
import com.threerings.presents.annotation.Transient;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.EntryEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.SetListener;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.protobuf.io.ProtobufRegistry;
import java.io.IOException;

public class EntryUpdatedEvent<T extends DSet.Entry>
extends EntryEvent<T>
implements ProtobufProvider<com.hexnova.narya.event.data.EntryUpdatedEvent> {
    protected T _entry;
    protected transient T _oldEntry = UNSET_OLD_ENTRY;
    @Transient
    private EntryUpdatedEvent.Builder builder = null;

    public EntryUpdatedEvent(int targetOid, String name, T entry) {
        super(targetOid, name);
        this._entry = entry;
    }

    @Override
    public Comparable<?> getKey() {
        return this._entry.getKey();
    }

    @Override
    public T getEntry() {
        return this._entry;
    }

    @Override
    public T getOldEntry() {
        return this._oldEntry;
    }

    @Override
    public boolean alreadyApplied() {
        return this._oldEntry != UNSET_OLD_ENTRY;
    }

    @Override
    public boolean applyToObject(DObject target) throws ObjectAccessException {
        if (!this.alreadyApplied()) {
            DSet set = target.getSet(this._name);
            this._oldEntry = set.update(this._entry);
            if (this._oldEntry == null) {
                Log.log.warning((Object)"No matching entry to update", new Object[]{"entry", this, "set", set});
                return false;
            }
        }
        return true;
    }

    @Override
    protected void notifyListener(Object listener) {
        if (listener instanceof SetListener) {
            SetListener setlist = (SetListener)listener;
            setlist.entryUpdated(this);
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        buf.append("ELUPD:");
        super.toString(buf);
        buf.append(", entry=");
        StringUtil.toString((StringBuilder)buf, this._entry);
    }

    protected EntryUpdatedEvent<T> setOldEntry(T oldEntry) {
        this._oldEntry = oldEntry;
        return this;
    }

    public EntryUpdatedEvent.Builder getBuilder() {
        if (this.builder == null) {
            this.builder = com.hexnova.narya.event.data.EntryUpdatedEvent.newBuilder();
        } else {
            this.builder.clear();
        }
        return this.builder;
    }

    @Override
    public void populate(com.hexnova.narya.event.data.EntryUpdatedEvent message) throws IOException {
        this._toid = (short)message.getToid();
        this._name = message.getName();
        if (message.hasEntry()) {
            this._entry = (DSet.Entry)ProtobufRegistry.fromAnyMessage(message.getEntry());
        }
    }

    @Override
    public com.hexnova.narya.event.data.EntryUpdatedEvent transform() throws IOException {
        EntryUpdatedEvent.Builder builder = this.getBuilder();
        builder.setToid(this._toid);
        builder.setName(this._name);
        if (this._entry != null) {
            builder.setEntry(ProtobufRegistry.toAnyMessage(this._entry));
        }
        return builder.build();
    }
}

