/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.hexnova.narya.event.data.ElementUpdatedEvent;
import com.samskivert.util.StringUtil;
import com.threerings.presents.annotation.Transient;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.ElementUpdateListener;
import com.threerings.presents.dobj.NamedEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.protobuf.io.ProtobufRegistry;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public class ElementUpdatedEvent
extends NamedEvent
implements ProtobufProvider<com.hexnova.narya.event.data.ElementUpdatedEvent> {
    protected Object _value;
    protected int _index;
    protected transient Object _oldValue = UNSET_OLD_VALUE;
    @Transient
    private ElementUpdatedEvent.Builder builder = null;

    public ElementUpdatedEvent(int targetOid, String name, Object value, int index) {
        super(targetOid, name);
        this._value = value;
        this._index = index;
    }

    public ElementUpdatedEvent() {
        super(0, null);
    }

    public Object getValue() {
        return this._value;
    }

    public Object getOldValue() {
        return this._oldValue;
    }

    public int getIndex() {
        return this._index;
    }

    public short getShortValue() {
        return (Short)this._value;
    }

    public int getIntValue() {
        return (Integer)this._value;
    }

    public long getLongValue() {
        return (Long)this._value;
    }

    public float getFloatValue() {
        return ((Float)this._value).floatValue();
    }

    public double getDoubleValue() {
        return (Double)this._value;
    }

    @Override
    public boolean alreadyApplied() {
        return this._oldValue != UNSET_OLD_VALUE;
    }

    @Override
    public boolean applyToObject(DObject target) throws ObjectAccessException {
        if (!this.alreadyApplied()) {
            try {
                Field field = target.getClass().getField(this._name);
                Class<?> ftype = field.getType();
                if (!ftype.isArray()) {
                    String msg = "Requested to set element on non-array field.";
                    throw new Exception(msg);
                }
                this._oldValue = Array.get(field.get(target), this._index);
                Array.set(field.get(target), this._index, this._value);
            }
            catch (Exception e) {
                String msg = "Error updating element [field=" + this._name + ", index=" + this._index + "]";
                throw new ObjectAccessException(msg, e);
            }
        }
        return true;
    }

    @Override
    protected void notifyListener(Object listener) {
        if (listener instanceof ElementUpdateListener) {
            ((ElementUpdateListener)listener).elementUpdated(this);
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        buf.append("UPDATE:");
        super.toString(buf);
        buf.append(", value=");
        StringUtil.toString((StringBuilder)buf, (Object)this._value);
        buf.append(", index=").append(this._index);
    }

    protected ElementUpdatedEvent setOldValue(Object oldValue) {
        this._oldValue = oldValue;
        return this;
    }

    public ElementUpdatedEvent.Builder getBuilder() {
        if (this.builder == null) {
            this.builder = com.hexnova.narya.event.data.ElementUpdatedEvent.newBuilder();
        } else {
            this.builder.clear();
        }
        return this.builder;
    }

    @Override
    public void populate(com.hexnova.narya.event.data.ElementUpdatedEvent message) throws IOException {
        this._toid = (short)message.getToid();
        this._name = message.getName();
        this._index = message.getIndex();
        if (message.hasValue()) {
            this._value = ProtobufRegistry.fromAnyMessage(message.getValue());
        }
    }

    @Override
    public com.hexnova.narya.event.data.ElementUpdatedEvent transform() throws IOException {
        ElementUpdatedEvent.Builder builder = this.getBuilder();
        builder.setToid(this._toid);
        builder.setName(this._name);
        builder.setIndex(this._index);
        if (this._value != null) {
            builder.setValue(ProtobufRegistry.toAnyMessage(this._value));
        }
        return builder.build();
    }
}

