/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.DebugChords;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMap;
import com.samskivert.util.Interval;
import com.samskivert.util.Queue;
import com.samskivert.util.StringUtil;
import com.threerings.presents.Log;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.Communicator;
import com.threerings.presents.dobj.CompoundEvent;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.ObjectDestroyedEvent;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.net.BootstrapData;
import com.threerings.presents.net.BootstrapNotification;
import com.threerings.presents.net.CompoundDownstreamMessage;
import com.threerings.presents.net.DownstreamMessage;
import com.threerings.presents.net.EventNotification;
import com.threerings.presents.net.FailureResponse;
import com.threerings.presents.net.ForwardEventRequest;
import com.threerings.presents.net.LogoffResponse;
import com.threerings.presents.net.Message;
import com.threerings.presents.net.ObjectResponse;
import com.threerings.presents.net.PongResponse;
import com.threerings.presents.net.SubscribeRequest;
import com.threerings.presents.net.UnsubscribeRequest;
import com.threerings.presents.net.UnsubscribeResponse;
import com.threerings.presents.net.UpdateThrottleMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ClientDObjectMgr
implements DObjectManager,
Runnable {
    protected Communicator _comm;
    protected Client _client;
    protected Interval _flusher;
    protected Queue<Object> _actions = new Queue();
    protected HashIntMap<DObject> _ocache = new HashIntMap();
    protected HashIntMap<DObject> _dead = new HashIntMap();
    protected HashIntMap<PendingRequest<?>> _penders = new HashIntMap();
    protected HashMap<Class<?>, Long> _delays = Maps.newHashMap();
    protected HashIntMap<FlushRecord> _flushes = new HashIntMap();
    protected static int DUMP_OTABLE_MODMASK = 576;
    protected static int DUMP_OTABLE_KEYCODE = 79;
    protected static final long FLUSH_INTERVAL = 30000L;

    public ClientDObjectMgr(Communicator comm, Client client) {
        this._comm = comm;
        this._client = client;
        DebugChords.registerHook((int)DUMP_OTABLE_MODMASK, (int)DUMP_OTABLE_KEYCODE, (DebugChords.Hook)new DebugChords.Hook(){

            public void invoke() {
                Log.log.info((Object)("Dumping " + ClientDObjectMgr.this._ocache.size() + " objects:"), new Object[0]);
                for (DObject obj : ClientDObjectMgr.this._ocache.values()) {
                    Log.log.info((Object)(String.valueOf(obj.getClass().getName()) + " " + obj), new Object[0]);
                }
            }
        });
        this._flusher = new Interval(client.getRunQueue()){

            public void expired() {
                ClientDObjectMgr.this.flushObjects();
            }
        };
        this._flusher.schedule(30000L, true);
    }

    @Override
    public boolean isManager(DObject object) {
        return false;
    }

    @Override
    public <T extends DObject> void subscribeToObject(int oid, Subscriber<T> target) {
        if (oid <= 0) {
            target.requestFailed(oid, new ObjectAccessException("Invalid oid " + oid + "."));
        } else {
            this.queueAction(oid, target, true);
        }
    }

    @Override
    public <T extends DObject> void unsubscribeFromObject(int oid, Subscriber<T> target) {
        this.queueAction(oid, target, false);
    }

    @Override
    public void postEvent(DEvent event) {
        this._comm.postMessage(new ForwardEventRequest(event));
    }

    @Override
    public void removedLastSubscriber(DObject obj, boolean deathWish) {
        Class<?> oclass = obj.getClass();
        for (Class<?> dclass : this._delays.keySet()) {
            if (!dclass.isAssignableFrom(oclass)) continue;
            long expire = System.currentTimeMillis() + this._delays.get(dclass);
            this._flushes.put(obj.getOid(), (Object)new FlushRecord(obj, expire));
            return;
        }
        this.flushObject(obj);
    }

    public void registerFlushDelay(Class<?> objclass, long delay) {
        this._delays.put(objclass, delay);
    }

    public void processMessage(Message msg) {
        if (this._client.getRunQueue().isRunning()) {
            this._actions.append((Object)msg);
            this._client.getRunQueue().postRunnable((Runnable)this);
        } else {
            Log.log.info((Object)"Dropping message as RunQueue is shutdown", new Object[]{"msg", msg});
        }
    }

    @Override
    public void run() {
        Object obj = this._actions.getNonBlocking();
        if (obj != null) {
            this.dispatchAction(obj);
        }
    }

    protected void dispatchAction(Object obj) {
        if (obj instanceof EventNotification) {
            this.dispatchEvent(((EventNotification)obj).getEvent());
        } else if (obj instanceof BootstrapNotification) {
            BootstrapData data = ((BootstrapNotification)obj).getData();
            this._client.gotBootstrap(data, this);
        } else if (obj instanceof ObjectResponse) {
            this.registerObjectAndNotify((ObjectResponse)obj);
        } else if (obj instanceof UnsubscribeResponse) {
            int oid = ((UnsubscribeResponse)obj).getOid();
            if (this._dead.remove(oid) == null) {
                Log.log.warning((Object)"Received unsub ACK from unknown object", new Object[]{"oid", oid});
            }
        } else if (obj instanceof FailureResponse) {
            this.notifyFailure(((FailureResponse)obj).getOid(), ((FailureResponse)obj).getMessage());
        } else if (obj instanceof PongResponse) {
            this._client.gotPong((PongResponse)obj);
        } else if (obj instanceof LogoffResponse) {
            this._client.gotLogoffResponse((LogoffResponse)obj);
        } else if (obj instanceof UpdateThrottleMessage) {
            UpdateThrottleMessage upmsg = (UpdateThrottleMessage)obj;
            this._client.setOutgoingMessageThrottle(upmsg.messagesPerSec);
        } else if (obj instanceof ObjectAction) {
            ObjectAction act = (ObjectAction)obj;
            if (act.subscribe) {
                this.doSubscribe(act);
            } else {
                this.doUnsubscribe(act.oid, act.target);
            }
        } else if (obj instanceof CompoundDownstreamMessage) {
            for (DownstreamMessage submsg : ((CompoundDownstreamMessage)obj).msgs) {
                this.dispatchAction(submsg);
            }
        } else {
            Log.log.warning((Object)"Unknown action", new Object[]{"action", obj});
        }
    }

    public void cleanup() {
        for (PendingRequest req : this._penders.values()) {
            for (Subscriber sub : req.targets) {
                sub.requestFailed(req.oid, new ObjectAccessException("Client connection closed"));
            }
        }
        this._penders.clear();
        this._flusher.cancel();
        this._flushes.clear();
        this._dead.clear();
        this._client.getRunQueue().postRunnable(new Runnable(){

            @Override
            public void run() {
                ClientDObjectMgr.this._ocache.clear();
            }
        });
    }

    protected <T extends DObject> void queueAction(int oid, Subscriber<T> target, boolean subscribe) {
        if (this._client.getRunQueue().isRunning()) {
            this._actions.append(new ObjectAction<T>(oid, target, subscribe));
            this._client.getRunQueue().postRunnable((Runnable)this);
        } else {
            Log.log.info((Object)"Dropping subscribe action as RunQueue is stopped", new Object[]{"oid", oid, "subscribe", subscribe});
        }
    }

    protected void dispatchEvent(DEvent event) {
        int remoteOid = event.getTargetOid();
        DObject target = (DObject)this._ocache.get(remoteOid);
        if (target == null) {
            if (!this._dead.containsKey(remoteOid)) {
                Log.log.warning((Object)("Unable to dispatch event on non-proxied object " + event + "."), new Object[0]);
            }
            return;
        }
        this._client.convertFromRemote(target, event);
        if (event instanceof CompoundEvent) {
            target.notifyProxies(event);
            List<DEvent> events = ((CompoundEvent)event).getEvents();
            int ecount = events.size();
            boolean[] notifys = new boolean[ecount];
            int ii = 0;
            while (ii < ecount) {
                try {
                    notifys[ii] = events.get(ii).applyToObject(target);
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Failure processing event", new Object[]{"event", event, "target", target, e});
                }
                ++ii;
            }
            ii = 0;
            while (ii < ecount) {
                this.dispatchEvent(remoteOid, target, events.get(ii), notifys[ii]);
                ++ii;
            }
        } else {
            target.notifyProxies(event);
            try {
                boolean notify = event.applyToObject(target);
                this.dispatchEvent(remoteOid, target, event, notify);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failure processing event", new Object[]{"event", event, "target", target, e});
            }
        }
    }

    protected void dispatchEvent(int remoteOid, DObject target, DEvent event, boolean notify) {
        try {
            if (event instanceof ObjectDestroyedEvent) {
                this._ocache.remove(remoteOid);
            }
            if (notify) {
                target.notifyListeners(event);
            }
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failure processing event", new Object[]{"event", event, "target", target, e});
        }
    }

    protected <T extends DObject> void registerObjectAndNotify(ObjectResponse<T> orsp) {
        T obj = orsp.getObject();
        ((DObject)obj).setManager(this);
        this._ocache.put(((DObject)obj).getOid(), obj);
        PendingRequest req = (PendingRequest)this._penders.remove(((DObject)obj).getOid());
        if (req == null) {
            Log.log.warning((Object)"Got object, but no one cares?!", new Object[]{"oid", ((DObject)obj).getOid(), "obj", obj});
            return;
        }
        int ii = 0;
        while (ii < req.targets.size()) {
            Subscriber<T> target = req.targets.get(ii);
            ((DObject)obj).addSubscriber(target);
            target.objectAvailable(obj);
            ++ii;
        }
    }

    protected void notifyFailure(int oid, String message) {
        PendingRequest req = (PendingRequest)this._penders.remove(oid);
        if (req == null) {
            Log.log.warning((Object)"Failed to get object, but no one cares?!", new Object[]{"oid", oid});
            return;
        }
        int ii = 0;
        while (ii < req.targets.size()) {
            req.targets.get(ii).requestFailed(oid, new ObjectAccessException(message));
            ++ii;
        }
    }

    protected <T extends DObject> void doSubscribe(ObjectAction<T> action) {
        int oid = action.oid;
        Subscriber<DObject> target = action.target;
        DObject obj = (DObject)this._ocache.get(oid);
        if (obj != null) {
            this._flushes.remove(oid);
            obj.addSubscriber(target);
            target.objectAvailable(obj);
            return;
        }
        PendingRequest<DObject> req = (PendingRequest<DObject>)this._penders.get(oid);
        if (req != null) {
            req.addTarget(target);
            return;
        }
        req = new PendingRequest<DObject>(oid);
        req.addTarget(target);
        this._penders.put(oid, req);
        this._comm.postMessage(new SubscribeRequest(oid));
    }

    protected void doUnsubscribe(int oid, Subscriber<?> target) {
        DObject dobj = (DObject)this._ocache.get(oid);
        if (dobj != null) {
            dobj.removeSubscriber(target);
        } else {
            Log.log.info((Object)"Requested to remove subscriber from non-proxied object", new Object[]{"oid", oid, "sub", target});
        }
    }

    protected void flushObject(DObject obj) {
        int ooid = obj.getOid();
        this._ocache.remove(ooid);
        this._dead.put(ooid, (Object)obj);
        this._comm.postMessage(new UnsubscribeRequest(ooid));
    }

    protected void flushObjects() {
        long now = System.currentTimeMillis();
        Iterator iter = this._flushes.intEntrySet().iterator();
        while (iter.hasNext()) {
            IntMap.IntEntry entry = (IntMap.IntEntry)iter.next();
            FlushRecord rec = (FlushRecord)entry.getValue();
            if (rec.expire > now) continue;
            iter.remove();
            this.flushObject(rec.object);
        }
    }

    protected static final class FlushRecord {
        public DObject object;
        public long expire;

        public FlushRecord(DObject object, long expire) {
            this.object = object;
            this.expire = expire;
        }
    }

    protected static final class ObjectAction<T extends DObject> {
        public int oid;
        public Subscriber<T> target;
        public boolean subscribe;

        public ObjectAction(int oid, Subscriber<T> target, boolean subscribe) {
            this.oid = oid;
            this.target = target;
            this.subscribe = subscribe;
        }

        public String toString() {
            return StringUtil.fieldsToString((Object)this);
        }
    }

    protected static final class PendingRequest<T extends DObject> {
        public int oid;
        public ArrayList<Subscriber<T>> targets = Lists.newArrayList();

        public PendingRequest(int oid) {
            this.oid = oid;
        }

        public void addTarget(Subscriber<T> target) {
            this.targets.add(target);
        }
    }
}

