/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.io;

import com.google.common.collect.Sets;
import com.threerings.io.ClassMapping;
import com.threerings.io.Streamer;
import com.threerings.protobuf.io.ProtobufOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;

public class UnreliableObjectOutputStream
extends ProtobufOutputStream {
    protected Set<Class<?>> _mappedClasses = Sets.newHashSet();
    protected Set<String> _mappedInterns = Sets.newHashSet();

    public UnreliableObjectOutputStream(OutputStream target) {
        super(target);
    }

    public void setMappedClasses(Set<Class<?>> mappedClasses) {
        this._mappedClasses = mappedClasses;
    }

    public Set<Class<?>> getMappedClasses() {
        return this._mappedClasses;
    }

    public void setMappedInterns(Set<String> mappedInterns) {
        this._mappedInterns = mappedInterns;
    }

    public Set<String> getMappedInterns() {
        return this._mappedInterns;
    }

    public void noteClassMappingsReceived(Collection<Class<?>> sclasses) {
        if (this._classmap == null) {
            throw new RuntimeException("Missing class map");
        }
        for (Class<?> sclass : sclasses) {
            ClassMapping cmap = (ClassMapping)this._classmap.get(sclass);
            if (cmap == null) {
                throw new RuntimeException("No class mapping for " + sclass.getName());
            }
            cmap.code = (short)Math.abs(cmap.code);
        }
    }

    public void noteInternMappingsReceived(Collection<String> sinterns) {
        if (this._internmap == null) {
            throw new RuntimeException("Missing intern map");
        }
        for (String sintern : sinterns) {
            Short code = (Short)this._internmap.get(sintern);
            if (code == null) {
                throw new RuntimeException("No intern mapping for " + sintern);
            }
            short scode = code;
            if (scode >= 0) continue;
            this._internmap.put(sintern, -code.shortValue());
        }
    }

    @Override
    protected Short createInternMapping(short code) {
        return -code;
    }

    @Override
    protected void writeNewInternMapping(short code, String value) throws IOException {
        this.writeInternMapping(code, value);
    }

    @Override
    protected void writeExistingInternMapping(short code, String value) throws IOException {
        if (code > 0) {
            this.writeShort(code);
        } else if (this._mappedInterns.contains(value)) {
            this.writeShort(-code);
        } else {
            this.writeInternMapping(code, value);
        }
    }

    @Override
    protected void writeInternMapping(int code, String value) throws IOException {
        super.writeInternMapping(code, value);
        this._mappedInterns.add(value);
    }

    @Override
    protected ClassMapping createClassMapping(short code, Class<?> sclass, Streamer streamer) {
        return new ClassMapping(-code, sclass, streamer);
    }

    @Override
    protected void writeNewClassMapping(ClassMapping cmap) throws IOException {
        this.writeClassMapping(cmap.code, cmap.sclass);
    }

    @Override
    protected void writeExistingClassMapping(ClassMapping cmap) throws IOException {
        if (cmap.code > 0) {
            this.writeShort(cmap.code);
        } else if (this._mappedClasses.contains(cmap.sclass)) {
            this.writeShort(-cmap.code);
        } else {
            this.writeClassMapping(cmap.code, cmap.sclass);
        }
    }

    @Override
    protected void writeClassMapping(int code, Class<?> sclass) throws IOException {
        super.writeClassMapping(code, sclass);
        this._mappedClasses.add(sclass);
    }
}

