/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.io;

import com.google.common.collect.Maps;
import com.threerings.NaryaLog;
import com.threerings.io.ClassMapping;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.Streamer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class ObjectOutputStream
extends DataOutputStream {
    protected Map<Class<?>, ClassMapping> _classmap;
    protected Map<String, Short> _internmap;
    protected short _nextClassCode = 1;
    protected short _nextInternCode = 1;
    protected Object _current;
    protected Streamer _streamer;
    protected Map<String, String> _translations;

    public ObjectOutputStream(OutputStream target) {
        super(target);
    }

    public void addTranslation(String className, String streamedName) {
        if (this._translations == null) {
            this._translations = Maps.newHashMap();
        }
        this._translations.put(className, streamedName);
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeShort(0);
            return;
        }
        Class<?> sclass = Streamer.getStreamerClass(object);
        ClassMapping cmap = this.writeClassMapping(sclass);
        this.writeBareObject(object, cmap.streamer, true);
    }

    public void writeIntern(String value) throws IOException {
        Short code;
        if (value == null) {
            this.writeShort(0);
            return;
        }
        if (this._internmap == null) {
            this._internmap = Maps.newHashMap();
        }
        if ((code = this._internmap.get(value)) == null) {
            if (ObjectInputStream.STREAM_DEBUG) {
                NaryaLog.log.info((Object)(String.valueOf(this.hashCode()) + ": Creating intern mapping"), new Object[]{"code", this._nextInternCode, "value", value});
            }
            short s = this._nextInternCode;
            this._nextInternCode = (short)(s + 1);
            code = this.createInternMapping(s);
            this._internmap.put(value.intern(), code);
            if (this._nextInternCode <= 0) {
                throw new RuntimeException("Too many unique interns written to ObjectOutputStream");
            }
            this.writeNewInternMapping(code, value);
        } else {
            this.writeExistingInternMapping(code, value);
        }
    }

    protected Short createInternMapping(short code) {
        return code;
    }

    protected void writeNewInternMapping(short code, String value) throws IOException {
        this.writeInternMapping(-code, value);
    }

    protected void writeExistingInternMapping(short code, String value) throws IOException {
        this.writeShort(code);
    }

    protected void writeInternMapping(int code, String value) throws IOException {
        this.writeShort(code);
        this.writeUTF(value);
    }

    protected ClassMapping writeClassMapping(Class<?> sclass) throws IOException {
        ClassMapping cmap;
        if (this._classmap == null) {
            this._classmap = Maps.newHashMap();
        }
        if ((cmap = this._classmap.get(sclass)) == null) {
            Class<?> collClass = Streamer.getCollectionClass(sclass);
            if (collClass != null && !collClass.equals(sclass)) {
                cmap = this.writeClassMapping(collClass);
                this._classmap.put(sclass, cmap);
                return cmap;
            }
            Streamer streamer = Streamer.getStreamer(sclass);
            if (ObjectInputStream.STREAM_DEBUG) {
                NaryaLog.log.info((Object)(String.valueOf(this.hashCode()) + ": Creating class mapping"), new Object[]{"code", this._nextClassCode, "class", sclass.getName()});
            }
            short s = this._nextClassCode;
            this._nextClassCode = (short)(s + 1);
            cmap = this.createClassMapping(s, sclass, streamer);
            this._classmap.put(sclass, cmap);
            if (this._nextClassCode <= 0) {
                throw new RuntimeException("Too many unique classes written to ObjectOutputStream");
            }
            this.writeNewClassMapping(cmap);
        } else {
            this.writeExistingClassMapping(cmap);
        }
        return cmap;
    }

    protected ClassMapping createClassMapping(short code, Class<?> sclass, Streamer streamer) {
        return new ClassMapping(code, sclass, streamer);
    }

    protected void writeNewClassMapping(ClassMapping cmap) throws IOException {
        this.writeClassMapping(-cmap.code, cmap.sclass);
    }

    protected void writeExistingClassMapping(ClassMapping cmap) throws IOException {
        this.writeShort(cmap.code);
    }

    protected void writeClassMapping(int code, Class<?> sclass) throws IOException {
        String tname;
        this.writeShort(code);
        String cname = sclass.getName();
        if (this._translations != null && (tname = this._translations.get(cname)) != null) {
            cname = tname;
        }
        this.writeUTF(cname);
    }

    public void writeBareObject(Object object) throws IOException {
        this.writeBareObject(object, Streamer.getStreamer(Streamer.getStreamerClass(object)), true);
    }

    protected void writeBareObject(Object obj, Streamer streamer, boolean useWriter) throws IOException {
        this._current = obj;
        this._streamer = streamer;
        try {
            this._streamer.writeObject(obj, this, useWriter);
        }
        finally {
            this._current = null;
            this._streamer = null;
        }
    }

    public void defaultWriteObject() throws IOException {
        if (this._current == null) {
            throw new RuntimeException("defaultWriteObject() called illegally.");
        }
        this._streamer.writeObject(this._current, this, false);
    }

    public void writeUnmodifiedUTF(String str) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        this.writeShort(bytes.length);
        this.write(bytes);
    }
}

