/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.io;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMap;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamer;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicStreamers {
    public static final Map<Class<?>, Streamer> BSTREAMERS = ImmutableMap.builder().put(Boolean.class, (Object)new BooleanStreamer()).put(Byte.class, (Object)new ByteStreamer()).put(Short.class, (Object)new ShortStreamer()).put(Character.class, (Object)new CharacterStreamer()).put(Integer.class, (Object)new IntegerStreamer()).put(Long.class, (Object)new LongStreamer()).put(Float.class, (Object)new FloatStreamer()).put(Double.class, (Object)new DoubleStreamer()).put(Date.class, (Object)new DateStreamer()).put(Class.class, (Object)new ClassStreamer()).put(String.class, (Object)(Boolean.getBoolean("com.threerings.io.unmodifiedUTFStreaming") ? new UnmodifiedUTFStringStreamer() : new StringStreamer())).put(boolean[].class, (Object)new BooleanArrayStreamer()).put(byte[].class, (Object)new ByteArrayStreamer()).put(short[].class, (Object)new ShortArrayStreamer()).put(char[].class, (Object)new CharArrayStreamer()).put(int[].class, (Object)new IntArrayStreamer()).put(long[].class, (Object)new LongArrayStreamer()).put(float[].class, (Object)new FloatArrayStreamer()).put(double[].class, (Object)new DoubleArrayStreamer()).put(Object[].class, (Object)new ObjectArrayStreamer()).put(List.class, (Object)ListStreamer.INSTANCE).put(Collection.class, (Object)ListStreamer.INSTANCE).put(Set.class, (Object)new SetStreamer()).put(IntMap.class, (Object)new IntMapStreamer()).put(Map.class, (Object)new MapStreamer()).put(Multiset.class, (Object)new MultisetStreamer()).put(Iterable.class, (Object)new IterableStreamer()).build();

    public static boolean[] readBooleanArray(ObjectInputStream ins) throws IOException {
        boolean[] value = new boolean[ins.readInt()];
        int ecount = value.length;
        int ii = 0;
        while (ii < ecount) {
            value[ii] = ins.readBoolean();
            ++ii;
        }
        return value;
    }

    public static byte[] readByteArray(ObjectInputStream ins) throws IOException {
        byte[] value = new byte[ins.readInt()];
        int remain = value.length;
        int offset = 0;
        while (remain > 0) {
            int read = ins.read(value, offset, remain);
            if (read > 0) {
                remain -= read;
                offset += read;
                continue;
            }
            throw new EOFException();
        }
        return value;
    }

    public static short[] readShortArray(ObjectInputStream ins) throws IOException {
        short[] value = new short[ins.readInt()];
        int ecount = value.length;
        int ii = 0;
        while (ii < ecount) {
            value[ii] = ins.readShort();
            ++ii;
        }
        return value;
    }

    public static char[] readCharArray(ObjectInputStream ins) throws IOException {
        char[] value = new char[ins.readInt()];
        int ecount = value.length;
        int ii = 0;
        while (ii < ecount) {
            value[ii] = ins.readChar();
            ++ii;
        }
        return value;
    }

    public static int[] readIntArray(ObjectInputStream ins) throws IOException {
        int[] value = new int[ins.readInt()];
        int ecount = value.length;
        int ii = 0;
        while (ii < ecount) {
            value[ii] = ins.readInt();
            ++ii;
        }
        return value;
    }

    public static long[] readLongArray(ObjectInputStream ins) throws IOException {
        long[] value = new long[ins.readInt()];
        int ecount = value.length;
        int ii = 0;
        while (ii < ecount) {
            value[ii] = ins.readLong();
            ++ii;
        }
        return value;
    }

    public static float[] readFloatArray(ObjectInputStream ins) throws IOException {
        float[] value = new float[ins.readInt()];
        int ecount = value.length;
        int ii = 0;
        while (ii < ecount) {
            value[ii] = ins.readFloat();
            ++ii;
        }
        return value;
    }

    public static double[] readDoubleArray(ObjectInputStream ins) throws IOException {
        double[] value = new double[ins.readInt()];
        int ecount = value.length;
        int ii = 0;
        while (ii < ecount) {
            value[ii] = ins.readDouble();
            ++ii;
        }
        return value;
    }

    public static Object[] readObjectArray(ObjectInputStream ins) throws IOException, ClassNotFoundException {
        Object[] value = new Object[ins.readInt()];
        int ecount = value.length;
        int ii = 0;
        while (ii < ecount) {
            value[ii] = ins.readObject();
            ++ii;
        }
        return value;
    }

    public static void writeBooleanArray(ObjectOutputStream out, boolean[] value) throws IOException {
        int ecount = value.length;
        out.writeInt(ecount);
        int ii = 0;
        while (ii < ecount) {
            out.writeBoolean(value[ii]);
            ++ii;
        }
    }

    public static void writeByteArray(ObjectOutputStream out, byte[] value) throws IOException {
        int ecount = value.length;
        out.writeInt(ecount);
        out.write(value);
    }

    public static void writeCharArray(ObjectOutputStream out, char[] value) throws IOException {
        int ecount = value.length;
        out.writeInt(ecount);
        int ii = 0;
        while (ii < ecount) {
            out.writeChar(value[ii]);
            ++ii;
        }
    }

    public static void writeShortArray(ObjectOutputStream out, short[] value) throws IOException {
        int ecount = value.length;
        out.writeInt(ecount);
        int ii = 0;
        while (ii < ecount) {
            out.writeShort(value[ii]);
            ++ii;
        }
    }

    public static void writeIntArray(ObjectOutputStream out, int[] value) throws IOException {
        int ecount = value.length;
        out.writeInt(ecount);
        int ii = 0;
        while (ii < ecount) {
            out.writeInt(value[ii]);
            ++ii;
        }
    }

    public static void writeLongArray(ObjectOutputStream out, long[] value) throws IOException {
        int ecount = value.length;
        out.writeInt(ecount);
        int ii = 0;
        while (ii < ecount) {
            out.writeLong(value[ii]);
            ++ii;
        }
    }

    public static void writeFloatArray(ObjectOutputStream out, float[] value) throws IOException {
        int ecount = value.length;
        out.writeInt(ecount);
        int ii = 0;
        while (ii < ecount) {
            out.writeFloat(value[ii]);
            ++ii;
        }
    }

    public static void writeDoubleArray(ObjectOutputStream out, double[] value) throws IOException {
        int ecount = value.length;
        out.writeInt(ecount);
        int ii = 0;
        while (ii < ecount) {
            out.writeDouble(value[ii]);
            ++ii;
        }
    }

    public static void writeObjectArray(ObjectOutputStream out, Object[] value) throws IOException {
        int ecount = value.length;
        out.writeInt(ecount);
        int ii = 0;
        while (ii < ecount) {
            out.writeObject(value[ii]);
            ++ii;
        }
    }

    public static abstract class BasicStreamer
    extends Streamer {
        @Override
        public void readObject(Object object, ObjectInputStream in, boolean useReader) throws IOException, ClassNotFoundException {
        }
    }

    public static class BooleanArrayStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return BasicStreamers.readBooleanArray(in);
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            BasicStreamers.writeBooleanArray(out, (boolean[])object);
        }
    }

    public static class BooleanStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return in.readBoolean();
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeBoolean((Boolean)object);
        }
    }

    public static class ByteArrayStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return BasicStreamers.readByteArray(in);
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            BasicStreamers.writeByteArray(out, (byte[])object);
        }
    }

    public static class ByteStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return in.readByte();
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeByte(((Byte)object).byteValue());
        }
    }

    public static class CharArrayStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return BasicStreamers.readCharArray(in);
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            BasicStreamers.writeCharArray(out, (char[])object);
        }
    }

    public static class CharacterStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return Character.valueOf(in.readChar());
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeChar(((Character)object).charValue());
        }
    }

    public static class ClassStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            return in.readClassMapping().sclass;
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeClassMapping((Class)object);
        }
    }

    protected static abstract class CollectionStreamer
    extends BasicStreamer {
        public static final List<Class<?>> SPECIFICITY_ORDER = ImmutableList.of(List.class, IntMap.class, Map.class, Set.class, Multiset.class, Collection.class, Iterable.class);

        protected CollectionStreamer() {
        }

        @Override
        public Object createObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            Collection<Object> coll = this.createCollection(size);
            int ii = 0;
            while (ii < size) {
                coll.add(in.readObject());
                ++ii;
            }
            return coll;
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            Collection coll = (Collection)object;
            out.writeInt(coll.size());
            for (Object o : coll) {
                out.writeObject(o);
            }
        }

        protected abstract Collection<Object> createCollection(int var1);
    }

    public static class DateStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return new Date(in.readLong());
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeLong(((Date)object).getTime());
        }
    }

    public static class DoubleArrayStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return BasicStreamers.readDoubleArray(in);
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            BasicStreamers.writeDoubleArray(out, (double[])object);
        }
    }

    public static class DoubleStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return in.readDouble();
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeDouble((Double)object);
        }
    }

    public static class FloatArrayStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return BasicStreamers.readFloatArray(in);
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            BasicStreamers.writeFloatArray(out, (float[])object);
        }
    }

    public static class FloatStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return Float.valueOf(in.readFloat());
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeFloat(((Float)object).floatValue());
        }
    }

    public static class IntArrayStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return BasicStreamers.readIntArray(in);
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            BasicStreamers.writeIntArray(out, (int[])object);
        }
    }

    public static class IntMapStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            IntMap<Object> map = this.createMap(size);
            int ii = 0;
            while (ii < size) {
                map.put(in.readInt(), in.readObject());
                ++ii;
            }
            return map;
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            IntMap map = (IntMap)object;
            out.writeInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                out.writeInt((Integer)entry.getKey());
                out.writeObject(entry.getValue());
            }
        }

        protected IntMap<Object> createMap(int size) {
            return new HashIntMap(size, 1.75f);
        }
    }

    public static class IntegerStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return in.readInt();
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeInt((Integer)object);
        }
    }

    public static class IterableStreamer
    extends ListStreamer {
        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            super.writeObject(Lists.newArrayList((Iterable)((Iterable)object)), out, useWriter);
        }
    }

    public static class ListStreamer
    extends CollectionStreamer {
        public static final ListStreamer INSTANCE = new ListStreamer();

        @Override
        protected Collection<Object> createCollection(int size) {
            return Lists.newArrayListWithCapacity((int)size);
        }
    }

    public static class LongArrayStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return BasicStreamers.readLongArray(in);
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            BasicStreamers.writeLongArray(out, (long[])object);
        }
    }

    public static class LongStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return in.readLong();
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeLong((Long)object);
        }
    }

    public static class MapStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            Map<Object, Object> map = this.createMap(size);
            int ii = 0;
            while (ii < size) {
                map.put(in.readObject(), in.readObject());
                ++ii;
            }
            return map;
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            Map map = (Map)object;
            out.writeInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }

        protected Map<Object, Object> createMap(int size) {
            return Maps.newHashMapWithExpectedSize((int)size);
        }
    }

    public static class MultisetStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            Multiset<Object> set = this.createMultiset(size);
            int ii = 0;
            while (ii < size) {
                set.add(in.readObject(), in.readInt());
                ++ii;
            }
            return set;
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            Multiset set = (Multiset)object;
            Set entrySet = set.entrySet();
            out.writeInt(entrySet.size());
            for (Multiset.Entry entry : entrySet) {
                out.writeObject(entry.getElement());
                out.writeInt(entry.getCount());
            }
        }

        protected Multiset<Object> createMultiset(int size) {
            return HashMultiset.create((int)size);
        }
    }

    public static class ObjectArrayStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            return BasicStreamers.readObjectArray(in);
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            BasicStreamers.writeObjectArray(out, (Object[])object);
        }
    }

    public static class SetStreamer
    extends CollectionStreamer {
        @Override
        protected Collection<Object> createCollection(int size) {
            return Sets.newHashSetWithExpectedSize((int)size);
        }
    }

    public static class ShortArrayStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return BasicStreamers.readShortArray(in);
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            BasicStreamers.writeShortArray(out, (short[])object);
        }
    }

    public static class ShortStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return in.readShort();
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeShort(((Short)object).shortValue());
        }
    }

    public static class StringStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return in.readUTF();
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeUTF((String)object);
        }
    }

    public static class UnmodifiedUTFStringStreamer
    extends BasicStreamer {
        @Override
        public Object createObject(ObjectInputStream in) throws IOException {
            return in.readUnmodifiedUTF();
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeUnmodifiedUTF((String)object);
        }
    }
}

