/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.io;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.hexnova.narya.util.ArrayMask;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import com.threerings.protobuf.io.ProtobufProvider;
import java.io.IOException;

public class ArrayMask
implements Streamable,
ProtobufProvider<Message> {
    protected byte[] _mask;

    public ArrayMask() {
    }

    public ArrayMask(int length) {
        int mlength = length / 8;
        if (length % 8 != 0) {
            ++mlength;
        }
        this._mask = new byte[mlength];
    }

    public void set(int index) {
        int n = index / 8;
        this._mask[n] = (byte)(this._mask[n] | 1 << index % 8);
    }

    public void unSet(int index) {
        int n = index / 8;
        this._mask[n] = (byte)(this._mask[n] & ~(1 << index % 8));
    }

    public boolean isSet(int index) {
        return (this._mask[index / 8] & 1 << index % 8) != 0;
    }

    public void writeTo(ObjectOutputStream out) throws IOException {
        out.writeShort(this._mask.length);
        out.write(this._mask);
    }

    public void readFrom(ObjectInputStream in) throws IOException {
        short length = in.readShort();
        this._mask = new byte[length];
        in.read(this._mask);
    }

    @Override
    public void populate(Message input) throws IOException {
        com.hexnova.narya.util.ArrayMask message = (com.hexnova.narya.util.ArrayMask)input;
        this._mask = message.getMask().toByteArray();
    }

    @Override
    public Message transform() throws IOException {
        ArrayMask.Builder builder = (ArrayMask.Builder)this.getBuilder();
        builder.setMask(ByteString.copyFrom((byte[])this._mask));
        return builder.build();
    }

    @Override
    public Message.Builder getBuilder() {
        return com.hexnova.narya.util.ArrayMask.newBuilder();
    }
}

