/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.threerings.crowd.Log;
import com.threerings.crowd.data.BodyMarshaller;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.crowd.server.BodyLocal;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.crowd.server.BodyProvider;
import com.threerings.crowd.server.PlaceManager;
import com.threerings.crowd.server.PlaceRegistry;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.server.InvocationManager;

@Singleton
public class BodyManager
implements BodyProvider {
    @Inject
    protected PlaceRegistry _plreg;
    @Inject
    protected BodyLocator _locator;

    @Inject
    public BodyManager(InvocationManager invmgr) {
        invmgr.registerProvider(this, BodyMarshaller.class, "crowd");
    }

    public <T extends OccupantInfo> boolean updateOccupantInfo(BodyObject body, OccupantInfo.Updater<T> updater) {
        PlaceManager pmgr = this._plreg.getPlaceManager(body.getPlaceOid());
        return pmgr == null ? false : pmgr.updateOccupantInfo(body.getOid(), updater);
    }

    public void updateOccupantStatus(BodyObject body, final byte status) {
        if (body.status != status) {
            body.setStatus(status);
            body.getLocal(BodyLocal.class).statusTime = System.currentTimeMillis();
        }
        this.updateOccupantInfo(body, new OccupantInfo.Updater<OccupantInfo>(){

            @Override
            public boolean update(OccupantInfo info) {
                if (info.status == status) {
                    return false;
                }
                info.status = status;
                return true;
            }
        });
    }

    @Override
    public void setIdle(ClientObject caller, boolean idle) {
        byte nstatus;
        BodyObject bobj = this._locator.forClient(caller);
        byte by = nstatus = idle ? (byte)1 : 0;
        if (bobj == null || bobj.status == nstatus) {
            return;
        }
        Log.log.debug((Object)"Setting user idle state", new Object[]{"user", bobj.username, "status", nstatus});
        this.updateOccupantStatus(bobj, nstatus);
    }
}

