/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.chat.server;

import com.samskivert.util.ObserverList;
import com.threerings.crowd.Log;
import com.threerings.crowd.chat.data.ChatMessage;
import com.threerings.crowd.chat.data.SpeakObject;
import com.threerings.crowd.chat.data.SystemMessage;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.crowd.data.BodyObject;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.util.Name;

public class SpeakUtil {
    protected static MessageMapper _messageMapper = new MessageMapper();
    protected static ObserverList<MessageObserver> _messageObs = ObserverList.newFastUnsafe();
    protected static MessageObserverOp _messageOp = new MessageObserverOp();

    public static void registerMessageObserver(MessageObserver obs) {
        _messageObs.add((Object)obs);
    }

    public static void removeMessageObserver(MessageObserver obs) {
        _messageObs.remove((Object)obs);
    }

    public static void sendSpeak(DObject speakObj, Name speaker, String bundle, String message) {
        SpeakUtil.sendSpeak(speakObj, speaker, bundle, message, (byte)0);
    }

    public static void sendSpeak(DObject speakObj, Name speaker, String bundle, String message, byte mode) {
        SpeakUtil.sendMessage(speakObj, new UserMessage(speaker, bundle, message, mode));
    }

    public static void sendInfo(DObject speakObj, String bundle, String message) {
        SpeakUtil.sendSystem(speakObj, bundle, message, (byte)0);
    }

    public static void sendFeedback(DObject speakObj, String bundle, String message) {
        SpeakUtil.sendSystem(speakObj, bundle, message, (byte)1);
    }

    public static void sendAttention(DObject speakObj, String bundle, String message) {
        SpeakUtil.sendSystem(speakObj, bundle, message, (byte)2);
    }

    public static void sendMessage(DObject speakObj, ChatMessage msg) {
        if (speakObj == null) {
            Log.log.warning((Object)("Dropping speak message, no speak obj '" + msg + "'."), new Object[]{new Exception()});
            return;
        }
        speakObj.postMessage("crowd.chat", msg);
        if (!(msg instanceof UserMessage)) {
            return;
        }
        if (speakObj instanceof SpeakObject) {
            SpeakUtil._messageMapper.omgr = (RootDObjectManager)speakObj.getManager();
            SpeakUtil._messageMapper.message = (UserMessage)msg;
            ((SpeakObject)((Object)speakObj)).applyToListeners(_messageMapper);
            SpeakUtil._messageMapper.omgr = null;
            SpeakUtil._messageMapper.message = null;
        } else {
            Log.log.info((Object)"Unable to note listeners", new Object[]{"dclass", speakObj.getClass(), "msg", msg});
        }
    }

    protected static void noteMessage(Name username, UserMessage msg) {
        if (msg.timestamp == 0L) {
            msg.timestamp = System.currentTimeMillis();
        }
        _messageOp.init(username, msg);
        _messageObs.apply((ObserverList.ObserverOp)_messageOp);
    }

    protected static void sendSystem(DObject speakObj, String bundle, String message, byte level) {
        SpeakUtil.sendMessage(speakObj, new SystemMessage(message, bundle, level));
    }

    protected static class MessageMapper
    implements SpeakObject.ListenerOp {
        public RootDObjectManager omgr;
        public UserMessage message;

        protected MessageMapper() {
        }

        @Override
        public void apply(int bodyOid) {
            DObject dobj = this.omgr.getObject(bodyOid);
            if (dobj != null && dobj instanceof BodyObject) {
                SpeakUtil.noteMessage(((BodyObject)dobj).getVisibleName(), this.message);
            }
        }

        @Override
        public void apply(Name username) {
            SpeakUtil.noteMessage(username, this.message);
        }
    }

    public static interface MessageObserver {
        public void messageDelivered(Name var1, UserMessage var2);
    }

    protected static class MessageObserverOp
    implements ObserverList.ObserverOp<MessageObserver> {
        protected Name _hearer;
        protected UserMessage _message;

        protected MessageObserverOp() {
        }

        public void init(Name hearer, UserMessage message) {
            this._hearer = hearer;
            this._message = message;
        }

        public boolean apply(MessageObserver observer) {
            observer.messageDelivered(this._hearer, this._message);
            return true;
        }
    }
}

