/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.chat.client;

import com.google.common.collect.Sets;
import com.samskivert.util.ObserverList;
import com.threerings.crowd.chat.client.ChatDirector;
import com.threerings.crowd.chat.client.ChatFilter;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.presents.client.BasicDirector;
import com.threerings.util.MessageBundle;
import com.threerings.util.Name;
import java.util.Collections;
import java.util.HashSet;

public class MuteDirector
extends BasicDirector
implements ChatFilter {
    protected ChatDirector _chatdir;
    protected HashSet<Name> _mutelist = Sets.newHashSet();
    protected ObserverList<MuteObserver> _observers = ObserverList.newFastUnsafe();

    public MuteDirector(CrowdContext ctx) {
        super(ctx);
    }

    public MuteDirector(CrowdContext ctx, Name[] list) {
        this(ctx);
        Collections.addAll(this._mutelist, list);
    }

    public void shutdown() {
        if (this._chatdir != null) {
            this._chatdir.removeChatFilter(this);
            this._chatdir = null;
        }
        this._ctx.getClient().removeClientObserver(this);
    }

    public void setChatDirector(ChatDirector chatdir) {
        if (this._chatdir == null) {
            this._chatdir = chatdir;
            this._chatdir.addChatFilter(this);
        }
    }

    public void addMuteObserver(MuteObserver obs) {
        this._observers.add((Object)obs);
    }

    public void removeMuteObserver(MuteObserver obs) {
        this._observers.remove((Object)obs);
    }

    public boolean isMuted(Name username) {
        return this._mutelist.contains(username);
    }

    public void setMuted(Name username, boolean mute) {
        boolean changed;
        boolean bl = changed = mute ? this._mutelist.add(username) : this._mutelist.remove(username);
        String feedback = mute ? "m.muted" : (changed ? "m.unmuted" : "m.notmuted");
        this._chatdir.displayFeedback(null, MessageBundle.tcompose((String)feedback, (Object)username));
        if (changed) {
            this.notifyObservers(username, mute);
        }
    }

    public Name[] getMuted() {
        return this._mutelist.toArray(new Name[this._mutelist.size()]);
    }

    @Override
    public String filter(String msg, Name otherUser, boolean outgoing) {
        if (otherUser != null && this.isMuted(otherUser)) {
            if (outgoing) {
                this._chatdir.displayFeedback(null, "m.no_tell_mute");
            }
            return null;
        }
        return msg;
    }

    protected void notifyObservers(final Name username, final boolean muted) {
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<MuteObserver>(){

            public boolean apply(MuteObserver observer) {
                observer.muteChanged(username, muted);
                return true;
            }
        });
    }

    public static interface MuteObserver {
        public void muteChanged(Name var1, boolean var2);
    }
}

