/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.bureau.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.util.Interval;
import com.samskivert.util.Invoker;
import com.samskivert.util.RunQueue;
import com.samskivert.util.StringUtil;
import com.threerings.bureau.Log;
import com.threerings.bureau.data.AgentObject;
import com.threerings.bureau.data.BureauAuthName;
import com.threerings.bureau.data.BureauCredentials;
import com.threerings.bureau.data.BureauMarshaller;
import com.threerings.bureau.server.BureauClientResolver;
import com.threerings.bureau.server.BureauProvider;
import com.threerings.bureau.server.BureauSender;
import com.threerings.bureau.server.BureauSession;
import com.threerings.bureau.util.BureauLogRedirector;
import com.threerings.presents.annotation.MainInvoker;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.server.ClientManager;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.PresentsSession;
import com.threerings.presents.server.ServiceAuthenticator;
import com.threerings.presents.server.SessionFactory;
import com.threerings.presents.server.net.PresentsConnectionManager;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;

@Singleton
public class BureauRegistry {
    protected Map<String, LauncherEntry> _launchers = Maps.newHashMap();
    protected Map<String, Bureau> _bureaus = Maps.newHashMap();
    @Inject
    protected RootDObjectManager _omgr;
    @Inject
    @MainInvoker
    protected Invoker _invoker;

    @Inject
    public BureauRegistry(InvocationManager invmgr, PresentsConnectionManager conmgr, ClientManager clmgr) {
        invmgr.registerProvider(new BureauProvider(){

            @Override
            public void bureauInitialized(ClientObject client, String bureauId) {
                BureauRegistry.this.bureauInitialized(client, bureauId);
            }

            @Override
            public void bureauError(ClientObject caller, String message) {
                BureauRegistry.this.bureauError(caller, message);
            }

            @Override
            public void agentCreated(ClientObject client, int agentId) {
                BureauRegistry.this.agentCreated(client, agentId);
            }

            @Override
            public void agentCreationFailed(ClientObject client, int agentId) {
                BureauRegistry.this.agentCreationFailed(client, agentId);
            }

            @Override
            public void agentDestroyed(ClientObject client, int agentId) {
                BureauRegistry.this.agentDestroyed(client, agentId);
            }
        }, BureauMarshaller.class, "bureau");
        conmgr.addChainedAuthenticator(new ServiceAuthenticator<BureauCredentials>(BureauCredentials.class, BureauAuthName.class){

            @Override
            protected boolean areValid(BureauCredentials creds) {
                return BureauRegistry.this.checkToken(creds) == null;
            }
        });
        clmgr.addSessionFactory(SessionFactory.newSessionFactory(BureauCredentials.class, this.getSessionClass(), BureauAuthName.class, this.getClientResolverClass()));
        clmgr.addClientObserver(new ClientManager.ClientObserver(){

            @Override
            public void clientSessionDidStart(PresentsSession client) {
                if (client.getCredentials() instanceof BureauCredentials) {
                    BureauRegistry.this.sessionDidStart(client, ((BureauCredentials)client.getCredentials()).clientId);
                }
            }

            @Override
            public void clientSessionDidEnd(PresentsSession client) {
                if (client.getCredentials() instanceof BureauCredentials) {
                    BureauRegistry.this.sessionDidEnd(client, ((BureauCredentials)client.getCredentials()).clientId);
                }
            }
        });
    }

    public String checkToken(BureauCredentials creds) {
        Bureau bureau = this._bureaus.get(creds.clientId);
        if (bureau == null) {
            return "Bureau " + creds.clientId + " not found";
        }
        if (bureau.clientObj != null) {
            return "Bureau " + creds.clientId + " already logged in";
        }
        if (!creds.areValid(bureau.token)) {
            return "Bureau " + creds.clientId + " does not match credentials token";
        }
        return null;
    }

    public void setCommandGenerator(String bureauType, CommandGenerator cmdGenerator) {
        this.setCommandGenerator(bureauType, cmdGenerator, 0);
    }

    public void setCommandGenerator(String bureauType, final CommandGenerator cmdGenerator, int timeout) {
        this.setLauncher(bureauType, new Launcher(){

            @Override
            public void launchBureau(String bureauId, String token) throws IOException {
                ProcessBuilder builder = new ProcessBuilder(cmdGenerator.createCommand(bureauId, token));
                builder.redirectErrorStream(true);
                Process process = builder.start();
                new BureauLogRedirector(bureauId, process.getInputStream());
            }

            public String toString() {
                return "DefaultLauncher for " + cmdGenerator;
            }
        }, timeout);
    }

    public void setLauncher(String bureauType, Launcher launcher) {
        this.setLauncher(bureauType, launcher, 0);
    }

    public void setLauncher(String bureauType, Launcher launcher, int timeout) {
        if (this._launchers.get(bureauType) != null) {
            Log.log.warning((Object)"Launcher for type already exists", new Object[]{"type", bureauType});
            return;
        }
        this._launchers.put(bureauType, new LauncherEntry(launcher, timeout));
    }

    public void startAgent(AgentObject agent) {
        agent.setLocal(AgentData.class, new AgentData());
        Bureau bureau = this._bureaus.get(agent.bureauId);
        if (bureau != null && bureau.ready()) {
            this._omgr.registerObject(agent);
            Log.log.info((Object)"Bureau ready, sending createAgent", new Object[]{"agent", agent.which()});
            BureauSender.createAgent(bureau.clientObj, agent.getOid());
            bureau.agentStates.put(agent, AgentState.STARTED);
            bureau.summarize();
            return;
        }
        if (bureau == null) {
            LauncherEntry launcherEntry = this._launchers.get(agent.bureauType);
            if (launcherEntry == null) {
                Log.log.warning((Object)"Launcher not found", new Object[]{"agent", agent.which()});
                return;
            }
            Log.log.info((Object)"Creating new bureau", new Object[]{"bureauId", agent.bureauId, "launcher", launcherEntry});
            bureau = new Bureau();
            bureau.bureauId = agent.bureauId;
            bureau.token = this.generateToken(bureau.bureauId);
            bureau.launcherEntry = launcherEntry;
            this._invoker.postUnit((Invoker.Unit)new LauncherUnit(bureau, this._omgr));
            this._bureaus.put(agent.bureauId, bureau);
        }
        this._omgr.registerObject(agent);
        bureau.agentStates.put(agent, AgentState.PENDING);
        Log.log.info((Object)"Bureau not ready, pending agent", new Object[]{"agent", agent.which()});
        bureau.summarize();
    }

    public void destroyAgent(AgentObject agent) {
        FoundAgent found = this.resolve(null, agent.getOid(), "destroyAgent");
        if (found == null) {
            return;
        }
        Log.log.info((Object)"Destroying agent", new Object[]{"agent", agent.which()});
        if (found.state == AgentState.PENDING) {
            found.bureau.agentStates.remove(found.agent);
            this._omgr.destroyObject(found.agent.getOid());
        } else if (found.state == AgentState.STARTED) {
            found.bureau.agentStates.put(found.agent, AgentState.STILL_BORN);
        } else if (found.state == AgentState.RUNNING) {
            BureauSender.destroyAgent(found.bureau.clientObj, agent.getOid());
            found.bureau.agentStates.put(found.agent, AgentState.DESTROYED);
        } else if (found.state == AgentState.DESTROYED || found.state == AgentState.STILL_BORN) {
            Log.log.warning((Object)"Ignoring request to destroy agent in unexpected state", new Object[]{"state", found.state, "agent", found.agent.which()});
        }
        found.bureau.summarize();
    }

    public PresentsSession lookupClient(String bureauId) {
        Bureau bureau = this._bureaus.get(bureauId);
        if (bureau == null) {
            return null;
        }
        return bureau.client;
    }

    public Exception getLaunchError(AgentObject agentObj) {
        AgentData data = agentObj.getLocal(AgentData.class);
        if (data == null) {
            return null;
        }
        return data.launchError;
    }

    protected void sessionDidStart(PresentsSession client, String id) {
        Bureau bureau = this._bureaus.get(id);
        if (bureau == null) {
            Log.log.warning((Object)"Starting session for unknown bureau", new Object[]{"id", id, "client", client});
            return;
        }
        if (bureau.client != null) {
            Log.log.warning((Object)"Multiple sessions for the same bureau", new Object[]{"id", id, "client", client, "bureau", bureau});
        }
        bureau.client = client;
    }

    protected void sessionDidEnd(PresentsSession client, String id) {
        Bureau bureau = this._bureaus.get(id);
        if (bureau == null) {
            Log.log.warning((Object)"Ending session for unknown bureau", new Object[]{"id", id, "client", client});
            return;
        }
        if (bureau.client == null) {
            Log.log.warning((Object)"Multiple logouts from the same bureau", new Object[]{"id", id, "client", client, "bureau", bureau});
        }
        bureau.client = null;
        this.clientDestroyed(bureau);
    }

    protected void bureauInitialized(ClientObject client, String bureauId) {
        Bureau bureau = this._bureaus.get(bureauId);
        if (bureau == null) {
            Log.log.warning((Object)"Initialization of non-existent bureau", new Object[]{"bureauId", bureauId});
            return;
        }
        bureau.clientObj = client;
        Log.log.info((Object)"Bureau created, launching pending agents", new Object[]{"bureau", bureau});
        HashSet pending = Sets.newHashSet();
        for (Map.Entry<AgentObject, AgentState> entry : bureau.agentStates.entrySet()) {
            if (entry.getValue() != AgentState.PENDING) continue;
            pending.add(entry.getKey());
        }
        for (AgentObject agent : pending) {
            Log.log.info((Object)"Creating agent", new Object[]{"agent", agent.which()});
            BureauSender.createAgent(bureau.clientObj, agent.getOid());
            bureau.agentStates.put(agent, AgentState.STARTED);
        }
        bureau.summarize();
    }

    protected void bureauError(ClientObject caller, String message) {
        for (Bureau bureau : this._bureaus.values()) {
            if (bureau.clientObj != caller) continue;
            Log.log.info((Object)"Bureau error occurred", new Object[]{"caller", caller.who(), "message", message, "bureau", bureau.bureauId});
            bureau.client.endSession();
            return;
        }
        Log.log.warning((Object)"Bureau error occurred in unregistered bureau", new Object[]{"caller", caller.who(), "message", message});
    }

    protected void agentCreated(ClientObject client, int agentId) {
        FoundAgent found = this.resolve(client, agentId, "agentCreated");
        if (found == null) {
            return;
        }
        Log.log.info((Object)"Agent creation confirmed", new Object[]{"agent", found.agent.which()});
        if (found.state == AgentState.STARTED) {
            found.bureau.agentStates.put(found.agent, AgentState.RUNNING);
            found.agent.setClientOid(client.getOid());
        } else if (found.state == AgentState.STILL_BORN) {
            BureauSender.destroyAgent(found.bureau.clientObj, agentId);
            found.bureau.agentStates.put(found.agent, AgentState.DESTROYED);
        } else if (found.state == AgentState.PENDING || found.state == AgentState.RUNNING || found.state == AgentState.DESTROYED) {
            Log.log.warning((Object)"Ignoring confirmation of creation of an agent in an unexpected state", new Object[]{"state", found.state, "agent", found.agent.which()});
        }
        found.bureau.summarize();
    }

    protected void agentCreationFailed(ClientObject client, int agentId) {
        FoundAgent found = this.resolve(client, agentId, "agentCreationFailed");
        if (found == null) {
            return;
        }
        Log.log.info((Object)"Agent creation failed", new Object[]{"agent", found.agent.which()});
        if (found.state == AgentState.STARTED || found.state == AgentState.STILL_BORN) {
            found.bureau.agentStates.remove(found.agent);
            this._omgr.destroyObject(found.agent.getOid());
        } else if (found.state == AgentState.PENDING || found.state == AgentState.RUNNING || found.state == AgentState.DESTROYED) {
            Log.log.warning((Object)"Ignoring failure of creation of an agent in an unexpected state", new Object[]{"state", found.state, "agent", found.agent.which()});
        }
        found.bureau.summarize();
    }

    protected void agentDestroyed(ClientObject client, int agentId) {
        FoundAgent found = this.resolve(client, agentId, "agentDestroyed");
        if (found == null) {
            return;
        }
        Log.log.info((Object)"Agent destruction confirmed", new Object[]{"agent", found.agent.which()});
        if (found.state == AgentState.DESTROYED) {
            found.bureau.agentStates.remove(found.agent);
            this._omgr.destroyObject(found.agent.getOid());
        } else if (found.state == AgentState.PENDING || found.state == AgentState.STARTED || found.state == AgentState.RUNNING || found.state == AgentState.STILL_BORN) {
            Log.log.warning((Object)"Ignoring confirmation of destruction of agent in unexpected state", new Object[]{"state", found.state, "agent", found.agent.which()});
        }
        found.bureau.summarize();
    }

    protected void clientDestroyed(Bureau bureau) {
        Log.log.info((Object)"Client destroyed, destroying all agents", new Object[]{"bureau", bureau});
        for (AgentObject agent : bureau.agentStates.keySet()) {
            this._omgr.destroyObject(agent.getOid());
        }
        bureau.agentStates.clear();
        if (this._bureaus.remove(bureau.bureauId) == null) {
            Log.log.info((Object)"Bureau not found to remove", new Object[]{"bureau", bureau});
        }
    }

    protected FoundAgent resolve(ClientObject client, int agentId, String resolver) {
        DObject dobj = this._omgr.getObject(agentId);
        if (dobj == null) {
            Log.log.warning((Object)"Non-existent agent", new Object[]{"function", resolver, "agentId", agentId});
            return null;
        }
        if (!(dobj instanceof AgentObject)) {
            Log.log.warning((Object)"Object not an agent", new Object[]{"function", resolver, "obj", dobj.getClass()});
            return null;
        }
        AgentObject agent = (AgentObject)dobj;
        Bureau bureau = this._bureaus.get(agent.bureauId);
        if (bureau == null) {
            Log.log.warning((Object)"Bureau not found for agent", new Object[]{"function", resolver, "agent", agent.which()});
            return null;
        }
        if (!bureau.agentStates.containsKey(agent)) {
            Log.log.warning((Object)"Bureau does not have agent", new Object[]{"function", resolver, "agent", agent.which()});
            return null;
        }
        if (client != null && bureau.clientObj != client) {
            Log.log.warning((Object)"Masquerading request", new Object[]{"function", resolver, "agent", agent.which(), "client", bureau.clientObj, "client", client});
            return null;
        }
        return new FoundAgent(bureau, agent, bureau.agentStates.get(agent));
    }

    protected String generateToken(String bureauId) {
        String tokenSource = String.valueOf(bureauId) + "@" + System.currentTimeMillis() + "r" + Math.random();
        return StringUtil.md5hex((String)tokenSource);
    }

    protected void launchTimeoutExpired(Bureau bureau) {
        if (bureau.clientObj != null) {
            return;
        }
        if (!this._bureaus.containsKey(bureau.bureauId)) {
            return;
        }
        this.handleLaunchError(bureau, null, "timeout");
    }

    protected void handleLaunchError(Bureau bureau, Exception error, String cause) {
        if (cause == null && error != null) {
            cause = error.getMessage();
        }
        Log.log.info((Object)"Bureau failed to launch", new Object[]{"bureau", bureau, "cause", cause});
        for (AgentObject agent : bureau.agentStates.keySet()) {
            agent.getLocal(AgentData.class).launchError = error;
            this._omgr.destroyObject(agent.getOid());
        }
        bureau.agentStates.clear();
        this._bureaus.remove(bureau.bureauId);
    }

    protected Class<? extends BureauSession> getSessionClass() {
        return BureauSession.class;
    }

    protected Class<? extends BureauClientResolver> getClientResolverClass() {
        return BureauClientResolver.class;
    }

    protected static class AgentData {
        Exception launchError;

        protected AgentData() {
        }
    }

    protected static enum AgentState {
        PENDING,
        STARTED,
        RUNNING,
        DESTROYED,
        STILL_BORN;

    }

    protected static class Bureau {
        LauncherEntry launcherEntry;
        boolean launched;
        String token;
        String bureauId;
        ClientObject clientObj;
        PresentsSession client;
        Map<AgentObject, AgentState> agentStates = Maps.newHashMap();

        protected Bureau() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[Bureau id=").append(this.bureauId).append(", client=");
            if (this.clientObj == null) {
                builder.append("null");
            } else {
                builder.append(this.clientObj.getOid());
            }
            builder.append(", launcherEntry=").append(this.launcherEntry);
            builder.append(", launched=").append(this.launched);
            builder.append(", totalAgents=").append(this.agentStates.size());
            this.agentSummary(builder.append(", ")).append("]");
            return builder.toString();
        }

        boolean ready() {
            return this.clientObj != null;
        }

        StringBuilder agentSummary(StringBuilder str) {
            int[] counts = new int[AgentState.values().length];
            for (Map.Entry<AgentObject, AgentState> me : this.agentStates.entrySet()) {
                int n = me.getValue().ordinal();
                counts[n] = counts[n] + 1;
            }
            AgentState[] agentStateArray = AgentState.values();
            int n = agentStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                AgentState state = agentStateArray[n2];
                if (state.ordinal() > 0) {
                    str.append(", ");
                }
                str.append(counts[state.ordinal()]).append(" ").append(state.name());
                ++n2;
            }
            return str;
        }

        void summarize() {
            StringBuilder str = new StringBuilder();
            str.append("Bureau ").append(this.bureauId).append(" [");
            this.agentSummary(str).append("]");
            Log.log.info((Object)str.toString(), new Object[0]);
        }

        void launch() throws IOException {
            this.launcherEntry.launcher.launchBureau(this.bureauId, this.token);
        }
    }

    public static interface CommandGenerator {
        public String[] createCommand(String var1, String var2);
    }

    protected static class FoundAgent {
        Bureau bureau;
        AgentObject agent;
        AgentState state;

        FoundAgent(Bureau bureau, AgentObject agent, AgentState state) {
            this.bureau = bureau;
            this.agent = agent;
            this.state = state;
        }
    }

    public static interface Launcher {
        public void launchBureau(String var1, String var2) throws IOException;
    }

    protected static class LauncherEntry {
        public Launcher launcher;
        public int timeout;

        public LauncherEntry(Launcher launcher, int timeout) {
            this.launcher = launcher;
            this.timeout = timeout;
        }

        public String toString() {
            return StringUtil.fieldsToString((Object)this);
        }
    }

    protected class LauncherUnit
    extends Invoker.Unit {
        protected Bureau _bureau;
        protected Exception _error;
        protected RunQueue _runQueue;

        LauncherUnit(Bureau bureau, RunQueue runQueue) {
            super("LauncherUnit for " + bureau + ": " + StringUtil.toString((Object)bureau.launcherEntry));
            this._bureau = bureau;
            this._runQueue = runQueue;
        }

        public boolean invoke() {
            try {
                this._bureau.launch();
            }
            catch (Exception e) {
                this._error = e;
            }
            return true;
        }

        public void handleResult() {
            if (this._error == null) {
                int timeout = this._bureau.launcherEntry.timeout;
                if (timeout != 0) {
                    new Interval(this._runQueue){

                        public void expired() {
                            BureauRegistry.this.launchTimeoutExpired(LauncherUnit.this._bureau);
                        }
                    }.schedule((long)timeout);
                }
                this._bureau.launched = true;
                this._bureau.launcherEntry = null;
                Log.log.info((Object)"Bureau launch requested", new Object[]{"bureau", this._bureau});
            } else {
                BureauRegistry.this.handleLaunchError(this._bureau, this._error, null);
            }
        }
    }
}

