//
// $Id$
//
// Narya library - tools for developing networked games
// Copyright (C) 2002-2012 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/narya/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.presents.net;

import java.io.IOException;

import com.google.protobuf.Message.Builder;
import com.threerings.protobuf.io.ProtobufProvider;

/**
 * Notifies the server that the client has received its {@link UpdateThrottleMessage}.
 */
public class ThrottleUpdatedMessage extends UpstreamMessage implements ProtobufProvider<com.hexnova.narya.net.ThrottleUpdatedMessage> 
{
    /** The number of messages allowed per second. */
    public int messagesPerSec;

    /**
     * Zero argument constructor used when unserializing an instance.
     */
    public ThrottleUpdatedMessage ()
    {
        this.messagesPerSec = 0;
    }

    public ThrottleUpdatedMessage (int messagesPerSec)
    {
        this.messagesPerSec = messagesPerSec;
    }
    

	@Override
	public void populate(com.hexnova.narya.net.ThrottleUpdatedMessage message) throws IOException {
		this.messageId = (short)message.getMessageId();
		this.messagesPerSec = message.getMessagesPerSec();
	}

	@Override
	public com.hexnova.narya.net.ThrottleUpdatedMessage transform() throws IOException {
		com.hexnova.narya.net.ThrottleUpdatedMessage.Builder builder = (com.hexnova.narya.net.ThrottleUpdatedMessage.Builder) getBuilder();
		builder.setMessageId(messageId);
		builder.setMessagesPerSec(messagesPerSec);
		return builder.build();
	}

	@Override
	public Builder getBuilder() {
		return com.hexnova.narya.net.ThrottleUpdatedMessage.newBuilder();
	}
}
