//
// $Id$
//
// Narya library - tools for developing networked games
// Copyright (C) 2002-2012 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/narya/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.presents.net;

import java.io.IOException;

import com.google.protobuf.Message.Builder;
import com.threerings.protobuf.io.ProtobufProvider;

/**
 * Requests to subscribe to a particular distributed object.
 */
public class SubscribeRequest extends UpstreamMessage implements ProtobufProvider<com.hexnova.narya.net.SubscribeRequest>
{
    /**
     * Zero argument constructor used when unserializing an instance.
     */
    public SubscribeRequest ()
    {
        super();
    }

    /**
     * Constructs a subscribe request for the distributed object with the
     * specified object id.
     */
    public SubscribeRequest (int oid)
    {
        _oid = oid;
    }

    /**
     * Returns the oid of the object to which we desire subscription.
     */
    public int getOid ()
    {
        return _oid;
    }

    @Override
    public String toString ()
    {
        return "[type=SUB, msgid=" + messageId + ", oid=" + _oid + "]";
    }

    /**
     * The object id of the distributed object to which we are
     * subscribing.
     */
    protected int _oid;

	@Override
	public void populate(com.hexnova.narya.net.SubscribeRequest message) throws IOException {
		_oid = message.getOid();
		this.messageId = (short)message.getMessageId();
	}

	@Override
	public com.hexnova.narya.net.SubscribeRequest transform() throws IOException {
		com.hexnova.narya.net.SubscribeRequest.Builder builder = getBuilder();
		builder.setMessageId(messageId);
		builder.setOid(_oid);
		return builder.build();
	}

	@Override
	public  com.hexnova.narya.net.SubscribeRequest.Builder getBuilder() {
		if(builder == null) {
			builder = com.hexnova.narya.net.SubscribeRequest.newBuilder();
		}
		return builder;
	}
	
	private transient com.hexnova.narya.net.SubscribeRequest.Builder builder = null;
}
