package com.threerings.presents.net;

import java.io.IOException;

import com.google.protobuf.Message.Builder;
import com.hexnova.narya.net.Channel;
import com.threerings.presents.annotation.Transient;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.util.Name;

public class SessionCredentials extends IdentCredentials implements ProtobufProvider<com.hexnova.narya.net.SessionCredentials>{

	private String username;
	private String _sessionKey;
	private long region;
	protected Name _ident;
	private String channel;

	@Override
	public Name getIdent() {
		if (_ident == null) {
			_ident = new Name(username);
		}
		return _ident;
	}

	public long getRegion() {
		return region;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public void setSessionKey(String _sessionKey) {
		this._sessionKey = _sessionKey;
	}

	public void setChannel(String channel) {
		this.channel = channel;
	}

	public void setRegion(long region) {
		this.region = region;
	}

	public String getSessionKey() {
		return _sessionKey;
	}

	public String getChannel() {
		return channel;
	}

	@Override
	public com.hexnova.narya.net.SessionCredentials.Builder getBuilder() {
		if(_builder == null) {
			_builder = com.hexnova.narya.net.SessionCredentials.newBuilder();
		}
		return _builder;
	}

	@Transient
	protected com.hexnova.narya.net.SessionCredentials.Builder _builder;

	@Override
	public void populate(com.hexnova.narya.net.SessionCredentials message) throws IOException {
		this.username = String.valueOf(message.getUserId());
		this._sessionKey = message.getToken();
		if(message.hasChannel()) {
			this.channel = message.getChannel().name();
		}
		
	}

	@Override
	public com.hexnova.narya.net.SessionCredentials transform() throws IOException {
		com.hexnova.narya.net.SessionCredentials.Builder builder = getBuilder();
		if(channel != null) {
			builder.setChannel(Channel.valueOf(channel));
		}
		if(_sessionKey != null) {
			builder.setToken(_sessionKey);
		}
		
		return builder.build();
	}
}