//
// $Id$
//
// Narya library - tools for developing networked games
// Copyright (C) 2002-2012 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/narya/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.presents.net;

import java.io.IOException;

import com.google.protobuf.Message.Builder;
import com.threerings.presents.annotation.Transient;
import com.threerings.presents.dobj.DEvent;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.protobuf.io.ProtobufRegistry;

/**
 * Forwards an event to the server for dispatch.
 */
public class ForwardEventRequest extends UpstreamMessage implements ProtobufProvider<com.hexnova.narya.net.ForwardEventRequest>
{
    /**
     * Zero argument constructor used when unserializing an instance.
     */
    public ForwardEventRequest ()
    {
        super();
    }

    /**
     * Constructs a forward event request for the supplied event.
     */
    public ForwardEventRequest (DEvent event)
    {
        _event = event;
    }

    /**
     * Returns the event that we wish to have forwarded.
     */
    public DEvent getEvent ()
    {
        return _event;
    }

    @Override
    public void setTransport (Transport transport)
    {
        // the event handles the transport
        _event.setTransport(transport);
    }

    @Override
    public Transport getTransport ()
    {
        return _event.getTransport();
    }

    @Override
    public String toString ()
    {
        return super.toString()+", [type=FWD, evt=" + _event + "]";
    }

    /** The event which we are forwarding. */
    protected DEvent _event;

	@Override
	public com.hexnova.narya.net.ForwardEventRequest.Builder getBuilder() {
		if(builder == null) {
			builder = com.hexnova.narya.net.ForwardEventRequest.newBuilder();
		}else {
   			builder.clear();
   		}
		return builder;
	}

	@Override
	public void populate(com.hexnova.narya.net.ForwardEventRequest message) throws IOException {
		this.messageId = (short)message.getMessageId();
		this._event = ProtobufRegistry.fromAnyMessage(message.getEvent());
	}

	@Override
	public com.hexnova.narya.net.ForwardEventRequest transform() throws IOException {
		com.hexnova.narya.net.ForwardEventRequest.Builder builder = getBuilder();
		builder.setEvent(ProtobufRegistry.toAnyMessage(this._event));
		builder.setMessageId(this.messageId);
		
		return builder.build();
	}
	
	@Transient
	private com.hexnova.narya.net.ForwardEventRequest.Builder builder = null;
}
