package com.threerings.presents.client;


import com.samskivert.util.RunAnywhere;
import com.threerings.presents.net.PingRequest;
import com.threerings.presents.net.PongResponse;

public class ServerTimeCalculator extends Thread implements PingPongObserver{

	public ServerTimeCalculator() {
		this.setDaemon(true);
	}
	
	public void run() {
		while(true) {
			try {
				sleep(100L);
				long now;
				long deta = (now = RunAnywhere.currentTimeMillis()) - _lastTick;
				_serverTime += deta;
				_lastTick = now;
			} catch (InterruptedException e) {
			}
		}
	}
	/** A reference to the most recently sent ping which we use to obtain
     * the appropriate send stamp when we get the corresponding receive
     * stamp. */
    protected PingRequest _ping;
    
    /**
     * Must be called when a ping message is sent to the server.
     */
    public void sentPing (PingRequest ping)
    {
        _ping = ping;
    }

    /**
     * Must be called when the pong response arrives back from the server.
     *
     * @return true if we've iterated sufficiently many times to establish
     * a stable time delta estimate.
     */
    public void gotPong (PongResponse pong)
    {
        if (_ping == null) {
            // an errant pong that is likely being processed late after
            // a new connection was opened.
        	return;
        }

		
		if (_ping.messageId != pong.messageId) {
			return;
		}

		// make a note of when the ping message was sent and when the pong
        // response was received (both in client time)
        long send = _ping.getPackStamp(), recv = pong.getUnpackStamp();
        _ping = null; // clear out the saved sent ping

        // make a note of when the pong response was sent (in server time)
        // and the processing delay incurred on the server
        long server = pong.getPackStamp(), delay = pong.getProcessDelay();

        // compute the network delay (round-trip time divided by two)
        long nettime = (recv - send - delay)/2;
        
        setServerTime(server + nettime);
    }
    
    public void setServerTime(long serverTime) {
    	_serverTime = serverTime;
    	_lastTick = RunAnywhere.currentTimeMillis();
    }
    
    public long getServerTime() {
    	return _serverTime;
    }
    protected long _lastTick = RunAnywhere.currentTimeMillis();
    protected long _serverTime;
   
}
