//
// $Id$
//
// Narya library - tools for developing networked games
// Copyright (C) 2002-2012 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/narya/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.presents.client;

import com.samskivert.util.ObserverList;
import com.threerings.presents.net.PingRequest;
import com.threerings.presents.net.PongResponse;

/**
 * Used to notify session and client observers.
 */
public class ObserverOps
{
    public abstract static class Session implements ObserverList.ObserverOp<SessionObserver>
    {
        public Session (com.threerings.presents.client.Client client) {
            _client = client;
        }

        public boolean apply (SessionObserver obs) {
            notify(obs);
            return true;
        }

        protected abstract void notify (SessionObserver obs);

        protected com.threerings.presents.client.Client _client;
    }

    public abstract static class Client extends Session
    {
        public Client (com.threerings.presents.client.Client client) {
            super(client);
        }

        @Override public void notify (SessionObserver obs) {
            if (obs instanceof ClientObserver) {
                notify((ClientObserver)obs);
            }
        }

        protected abstract void notify (ClientObserver obs);
    }
    
    
    public static class Ping implements ObserverList.ObserverOp<PingPongObserver>
    {
        public Ping (com.threerings.presents.client.Client client,PingRequest ping) {
            _client = client;
            _ping = ping;
        }

        public boolean apply (PingPongObserver obs) {
            notify(obs);
            return true;
        }

        protected void notify (PingPongObserver obs) {
        	 obs.sentPing(_ping);
        }
        
        protected PingRequest _ping;
        protected com.threerings.presents.client.Client _client;
    }
    
    public static class Pong implements ObserverList.ObserverOp<PingPongObserver>
    {
        public Pong (com.threerings.presents.client.Client client, PongResponse pong) {
            _client = client;
            _pong = pong;
        }

        public boolean apply (PingPongObserver obs) {
            notify(obs);
            return true;
        }

        protected void notify (PingPongObserver obs) {
       	 obs.gotPong(_pong);
       }
        protected PongResponse _pong;
        protected com.threerings.presents.client.Client _client;
    }
    
}
