//
// $Id$
//
// Narya library - tools for developing networked games
// Copyright (C) 2002-2012 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/narya/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.crowd.chat.data;

import java.io.IOException;

import javax.annotation.Generated;

import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.InvocationMarshaller;
import com.google.protobuf.Message;
import com.threerings.crowd.chat.client.ChannelSpeakService;

/**
 * Provides the implementation of the {@link ChannelSpeakService} interface
 * that marshalls the arguments and delivers the request to the provider
 * on the server. Also provides an implementation of the response listener
 * interfaces that marshall the response arguments and deliver them back
 * to the requesting client.
 */
@Generated(value={"com.threerings.presents.tools.GenServiceTask"},
           comments="Derived from ChannelSpeakService.java.")
public class ChannelSpeakMarshaller extends InvocationMarshaller<ClientObject>
    implements ChannelSpeakService
{
    /** The method id used to dispatch {@link #speak} requests. */
    public static final int SPEAK = 1;

    // from interface ChannelSpeakService
    public void speak (ChatChannel arg1, String arg2, byte arg3)
    {
        sendRequest(SPEAK, new Object[] {
            arg1, arg2, Byte.valueOf(arg3)
        });
    }
    
    @Override
 	public void populate(Message msg) throws IOException {
     	com.hexnova.narya.net.BodyMarshaller message = (com.hexnova.narya.net.BodyMarshaller)msg;
     	this._invOid = message.getInvOid();
     	this._invCode = message.getInvCode();
     	if(message.hasContextKey()) {
     		this.contextKey = message.getContextKey();
     	}
 	}

 	@Override
 	public Message transform() throws IOException {
 		com.hexnova.narya.net.BodyMarshaller.Builder builder = (com.hexnova.narya.net.BodyMarshaller.Builder)getBuilder();
 		builder.setInvCode(_invCode);
 		builder.setInvOid(_invOid);
 		if(contextKey != null) {
 			builder.setContextKey(contextKey);
 		}
 		return builder.build();
 	}

 	@Override
 	public  Message.Builder getBuilder() {
 		if(builder == null) {
 			builder = com.hexnova.narya.net.BodyMarshaller.newBuilder();
 		}
 		return builder;
 	}
 	
 	private transient com.hexnova.narya.net.BodyMarshaller.Builder builder = null;
}
