/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.protobuf.io;

import com.google.common.collect.Maps;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.hexnova.narya.util.AnyMessage;
import com.threerings.io.Streamable;
import com.threerings.protobuf.io.ByteArrayDataInputStream;
import com.threerings.protobuf.io.ConstructorHelper;
import com.threerings.protobuf.io.ProtobufHelper;
import com.threerings.protobuf.io.ProtobufProvider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;

public class ProtobufRegistry {
    private static final Map<Integer, Class<? extends Streamable>> streamableMap = Maps.newHashMap();
    private static final Map<Integer, Class<? extends Message>> messageMap = Maps.newHashMap();
    private static final Map<Class<? extends Message>, Integer> messageType = Maps.newHashMap();
    private static final Map<Class<? extends Streamable>, Integer> streamableType = Maps.newHashMap();
    private static final Map<String, Class<? extends Message>> stringMessage = Maps.newHashMap();
    private static final Map<Class, Method> builderMethodMap = Maps.newHashMap();
    private static final Map<Class, ConstructorHelper> constructorHelperMap = Maps.newHashMap();

    static {
        ProtobufHelper.registType();
    }

    private ProtobufRegistry() {
    }

    public static void regist(int key, Class<? extends Streamable> value, Class<? extends Message> msg) {
        streamableMap.put(key, value);
        streamableType.put(value, key);
        messageMap.put(key, msg);
        messageType.put(msg, key);
        try {
            Class<? extends Message> mclazz = msg;
            Method method = null;
            method = builderMethodMap.get(mclazz);
            if (method == null) {
                method = mclazz.getMethod("newBuilder", new Class[0]);
                builderMethodMap.put(mclazz, method);
            }
            Message.Builder builder = (Message.Builder)method.invoke(null, new Object[0]);
            Message messageV3 = builder.build();
            stringMessage.put(messageV3.getDescriptorForType().getFullName(), msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T extends Message> T newMessage(String suffix, byte[] data) {
        try {
            Class<? extends Message> t = ProtobufRegistry.getMessageType(suffix);
            Message.Builder builder = (Message.Builder)t.getMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
            builder.mergeFrom(data);
            return (T)builder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T createObject(Class target) throws Exception {
        ConstructorHelper helper = constructorHelperMap.get(target);
        if (helper == null) {
            helper = new ConstructorHelper(target);
            constructorHelperMap.put(target, helper);
        }
        return helper.createObject();
    }

    public static <T> T fromAnyMessage(AnyMessage any) {
        block16: {
            if (any.getType() >= 100) {
                Class<? extends Message> mclazz = ProtobufRegistry.getMessageType(any.getType());
                Method method = null;
                method = builderMethodMap.get(mclazz);
                if (method == null) {
                    method = mclazz.getMethod("newBuilder", new Class[0]);
                    builderMethodMap.put(mclazz, method);
                }
                Message.Builder builder = (Message.Builder)method.invoke(null, new Object[0]);
                builder = builder.mergeFrom(any.getValue());
                Class<? extends Streamable> sclazz = ProtobufRegistry.getStreamableType(any.getType());
                T stream = ProtobufRegistry.createObject(sclazz);
                if (stream instanceof ProtobufProvider) {
                    ((ProtobufProvider)stream).populate(builder.build());
                }
                return stream;
            }
            if (any.getType() != 0) break block16;
            return null;
        }
        try {
            ByteArrayDataInputStream bis = new ByteArrayDataInputStream(any.getValue().toByteArray());
            switch (any.getType()) {
                case 1: {
                    return (T)any.getValue().toStringUtf8();
                }
                case 2: {
                    return (T)Byte.valueOf(any.toByteArray()[0]);
                }
                case 3: {
                    return (T)Integer.valueOf(bis.readInt());
                }
                case 4: {
                    return (T)Long.valueOf(bis.readLong());
                }
                case 5: {
                    return (T)Float.valueOf(bis.readFloat());
                }
                case 6: {
                    return (T)Double.valueOf(bis.readDouble());
                }
                case 7: {
                    return (T)Boolean.valueOf(bis.readBoolean());
                }
                case 8: {
                    return (T)any.toByteArray();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static AnyMessage toAnyMessage(Object obj) {
        if (obj == null) {
            return AnyMessage.newBuilder().build();
        }
        if (obj instanceof ProtobufProvider) {
            try {
                Object message = ((ProtobufProvider)obj).transform();
                byte[] bts = message.toByteArray();
                int type = ProtobufRegistry.getTypeByStreamable(obj.getClass());
                AnyMessage.Builder builder = AnyMessage.newBuilder();
                builder.setType(type);
                builder.setValue(ByteString.copyFrom((byte[])bts));
                return builder.build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Class<?> clazz = obj.getClass();
        AnyMessage.Builder builder = AnyMessage.newBuilder();
        if (clazz == String.class) {
            builder.setType(1);
            builder.setValue(ByteString.copyFromUtf8((String)((String)obj)));
        } else if (clazz == Byte.TYPE || clazz == Byte.class) {
            builder.setType(2);
            builder.setValue(ByteString.copyFrom((byte[])new byte[]{(Byte)obj}));
        } else if (clazz == Integer.TYPE || clazz == Integer.class) {
            builder.setType(3);
            byte[] writeBuffer = new byte[4];
            int v = (Integer)obj;
            writeBuffer[0] = (byte)(v >>> 24 & 0xFF);
            writeBuffer[1] = (byte)(v >>> 16 & 0xFF);
            writeBuffer[2] = (byte)(v >>> 8 & 0xFF);
            writeBuffer[3] = (byte)(v >>> 0 & 0xFF);
            builder.setValue(ByteString.copyFrom((byte[])writeBuffer));
        } else if (clazz == Long.TYPE || clazz == Long.class) {
            builder.setType(4);
            byte[] writeBuffer = new byte[8];
            long v = (Long)obj;
            writeBuffer[0] = (byte)(v >>> 56);
            writeBuffer[1] = (byte)(v >>> 48);
            writeBuffer[2] = (byte)(v >>> 40);
            writeBuffer[3] = (byte)(v >>> 32);
            writeBuffer[4] = (byte)(v >>> 24);
            writeBuffer[5] = (byte)(v >>> 16);
            writeBuffer[6] = (byte)(v >>> 8);
            writeBuffer[7] = (byte)(v >>> 0);
            builder.setValue(ByteString.copyFrom((byte[])writeBuffer));
        } else if (clazz == Float.TYPE || clazz == Float.class) {
            builder.setType(5);
            byte[] writeBuffer = new byte[4];
            int v = Float.floatToIntBits(((Float)obj).floatValue());
            writeBuffer[0] = (byte)(v >>> 24 & 0xFF);
            writeBuffer[1] = (byte)(v >>> 16 & 0xFF);
            writeBuffer[2] = (byte)(v >>> 8 & 0xFF);
            writeBuffer[3] = (byte)(v >>> 0 & 0xFF);
            builder.setValue(ByteString.copyFrom((byte[])writeBuffer));
        } else if (clazz == Double.TYPE || clazz == Double.class) {
            builder.setType(6);
            byte[] writeBuffer = new byte[8];
            long v = (int)Double.doubleToLongBits((Double)obj);
            writeBuffer[0] = (byte)(v >>> 56);
            writeBuffer[1] = (byte)(v >>> 48);
            writeBuffer[2] = (byte)(v >>> 40);
            writeBuffer[3] = (byte)(v >>> 32);
            writeBuffer[4] = (byte)(v >>> 24);
            writeBuffer[5] = (byte)(v >>> 16);
            writeBuffer[6] = (byte)(v >>> 8);
            writeBuffer[7] = (byte)(v >>> 0);
            builder.setValue(ByteString.copyFrom((byte[])writeBuffer));
        } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            builder.setType(7);
            boolean v = (Boolean)obj;
            builder.setValue(ByteString.copyFrom((byte[])new byte[]{v ? (byte)1 : 0}));
        } else if (clazz == byte[].class || clazz == Byte[].class) {
            builder.setType(8);
            builder.setValue(ByteString.copyFrom((byte[])((byte[])obj)));
        } else {
            throw new IllegalArgumentException(obj.getClass() + " is not registed");
        }
        return builder.build();
    }

    public static Object fromAny(Any any) {
        try {
            if (any.is(StringValue.class)) {
                return ((StringValue)any.unpack(StringValue.class)).getValue();
            }
            if (any.is(Int32Value.class)) {
                return ((Int32Value)any.unpack(Int32Value.class)).getValue();
            }
            if (any.is(Int64Value.class)) {
                return ((Int64Value)any.unpack(Int64Value.class)).getValue();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Any toAny(Object value) {
        try {
            if (value instanceof String) {
                return Any.pack((Message)StringValue.of((String)((String)value)));
            }
            if (value instanceof Integer) {
                return Any.pack((Message)Int32Value.of((int)((Integer)value)));
            }
            if (value instanceof Long) {
                return Any.pack((Message)Int64Value.of((long)((Long)value)));
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends Message> T newMessage(int type, byte[] data) {
        try {
            Class<? extends Message> t = ProtobufRegistry.getMessageType(type);
            Message.Builder builder = (Message.Builder)t.getMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
            builder.mergeFrom(data);
            return (T)builder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T transform(Message message) throws IOException {
        Class<? extends Streamable> t = ProtobufRegistry.getStreamableByMessage(message.getClass());
        try {
            T obj = ProtobufRegistry.createObject(t);
            if (obj instanceof ProtobufProvider) {
                ((ProtobufProvider)obj).populate(message);
            }
            return obj;
        }
        catch (Exception e) {
            new IOException(e);
            return null;
        }
    }

    public static Class<? extends Streamable> getStreamableType(int key) {
        return streamableMap.get(key);
    }

    public static Class<? extends Message> getMessageType(int key) {
        return messageMap.get(key);
    }

    public static Class<? extends Message> getMessageType(String key) {
        return stringMessage.get(key);
    }

    public static int getTypeByStreamable(Class type) {
        Integer value = null;
        value = streamableType.get(type);
        if (value == null) {
            throw new RuntimeException("type=" + type.getName() + ",not registed");
        }
        return value;
    }

    public static Class<? extends Message> getProtoMessageByStreamable(Class type) {
        int key = streamableType.get(type);
        return ProtobufRegistry.getMessageType(key);
    }

    public static Class<? extends Streamable> getStreamableByMessage(Class type) {
        Integer value = null;
        value = messageType.get(type);
        if (value == null) {
            throw new RuntimeException("type=" + type.getName() + ",not registed");
        }
        return ProtobufRegistry.getStreamableType(value);
    }

    public static int getTypeByMessage(Class type) {
        return messageType.get(type);
    }
}

