/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.protobuf.io;

import com.threerings.io.ObjectOutputStream;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.protobuf.io.ProtobufRegistry;
import java.io.IOException;
import java.io.OutputStream;

public class ProtobufOutputStream
extends ObjectOutputStream {
    public ProtobufOutputStream(OutputStream target) {
        super(target);
    }

    @Override
    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeShort(0);
            return;
        }
        if (object instanceof ProtobufProvider) {
            int type = ProtobufRegistry.getTypeByStreamable(object.getClass());
            this.writeInt(type);
            this.writeBareObject(object);
        } else {
            super.writeObject(object);
        }
    }

    @Override
    public void writeBareObject(Object object) throws IOException {
        this._current = object;
        try {
            this.defaultWriteObject();
        }
        finally {
            this._current = null;
        }
    }

    @Override
    public void defaultWriteObject() throws IOException {
        if (this._current == null) {
            throw new RuntimeException("defaultWriteObject() called illegally.");
        }
        if (this._current instanceof ProtobufProvider) {
            ProtobufProvider provider = (ProtobufProvider)this._current;
            byte[] bts = provider.transform().toByteArray();
            this.write(bts);
        }
    }
}

