/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.protobuf.io;

import com.google.protobuf.Message;
import com.samskivert.util.StringUtil;
import com.threerings.NaryaLog;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.Streamable;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.protobuf.io.ProtobufRegistry;
import java.io.IOException;
import java.io.InputStream;

public class ProtobufInputStream
extends ObjectInputStream {
    public ProtobufInputStream(InputStream source) {
        super(source);
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        Class<? extends Streamable> clazz;
        block5: {
            try {
                clazz = this.readClass();
                if (clazz != null) break block5;
                return null;
            }
            catch (OutOfMemoryError oome) {
                throw (IOException)new IOException("Malformed object data").initCause(oome);
            }
        }
        Streamable target = null;
        try {
            target = clazz.newInstance();
        }
        catch (Exception e) {
            throw new IOException(e.getCause());
        }
        this.readBareObject(target);
        return target;
    }

    protected Class<? extends Streamable> readClass() throws IOException, ClassNotFoundException {
        Class<? extends Streamable> clazz;
        int code = this.readInt();
        if (code == 0) {
            return null;
        }
        if (code < 0) {
            code *= -1;
        }
        if ((clazz = ProtobufRegistry.getStreamableType(code)) == null) {
            NaryaLog.log.warning((Object)"Internal stream error, no class metadata", new Object[]{"code", code, "ois", this, new Exception()});
            String string = "Read object code for which we have no Message class metadata [code=" + code + "]";
        }
        return clazz;
    }

    @Override
    public void readBareObject(Object object) throws IOException, ClassNotFoundException {
        this._current = object;
        try {
            if (this._current instanceof ProtobufProvider) {
                Message.Builder builder = ((ProtobufProvider)this._current).getBuilder();
                builder.mergeFrom((InputStream)this);
                Message message = builder.build();
                ((ProtobufProvider)this._current).populate(message);
            }
        }
        finally {
            this._current = null;
        }
    }

    @Override
    public void defaultReadObject() throws IOException, ClassNotFoundException {
        if (this._current == null) {
            throw new RuntimeException("defaultReadObject() called illegally.");
        }
        if (this._current instanceof ProtobufProvider) {
            Message.Builder builder = ((ProtobufProvider)this._current).getBuilder();
            builder.mergeFrom((InputStream)this);
            Message message = builder.build();
            ((ProtobufProvider)this._current).populate(message);
        }
    }

    @Override
    public String toString() {
        return "[hash=" + this.hashCode() + ", current=" + StringUtil.safeToString((Object)this._current) + "]";
    }
}

