/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.util;

import com.samskivert.util.StringUtil;
import com.threerings.presents.Log;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.Subscriber;

public class SafeSubscriber<T extends DObject>
implements Subscriber<T> {
    protected ChangeListener[] _listeners;
    protected int _oid;
    protected Subscriber<T> _subscriber;
    protected T _object;
    protected boolean _active;
    protected boolean _pending;

    public SafeSubscriber(int oid, Subscriber<T> subscriber, ChangeListener ... listeners) {
        if (oid <= 0) {
            throw new IllegalArgumentException("Invalid oid provided to safesub [oid=" + oid + "]");
        }
        if (subscriber == null) {
            throw new IllegalArgumentException("Null subscriber provided to safesub [oid=" + oid + "]");
        }
        this._oid = oid;
        this._subscriber = subscriber;
        this._listeners = listeners;
    }

    public boolean isActive() {
        return this._active;
    }

    public void subscribe(DObjectManager omgr) {
        if (this._active) {
            Log.log.warning((Object)("Active safesub asked to resubscribe " + this + "."), new Object[]{new Exception()});
            return;
        }
        this._active = true;
        if (this._object != null) {
            Log.log.warning((Object)("Incroyable! A safesub has an object and was non-active!? " + this + "."), new Object[]{new Exception()});
            this._subscriber.objectAvailable(this._object);
            return;
        }
        if (this._pending) {
            return;
        }
        this._pending = true;
        omgr.subscribeToObject(this._oid, this);
    }

    public void unsubscribe(DObjectManager omgr) {
        if (!this._active) {
            if (this._object == null && !this._pending) {
                return;
            }
            Log.log.warning((Object)("Inactive safesub asked to unsubscribe " + this + "."), new Object[]{new Exception()});
        }
        this._active = false;
        if (this._pending) {
            if (this._object != null) {
                Log.log.warning((Object)("Incroyable! A safesub has an object and is pending!? " + this + "."), new Object[]{new Exception()});
            } else {
                return;
            }
        }
        if (this._object == null) {
            Log.log.warning((Object)("Zut alors! A safesub _was_ active and not pending yet has no object!? " + this + "."), new Object[]{new Exception()});
            return;
        }
        ChangeListener[] changeListenerArray = this._listeners;
        int n = this._listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeListener listener = changeListenerArray[n2];
            ((DObject)this._object).removeListener(listener);
            ++n2;
        }
        this._object = null;
        omgr.unsubscribeFromObject(this._oid, this);
    }

    @Override
    public void objectAvailable(T object) {
        if (this._object != null) {
            Log.log.warning((Object)("Madre de dios! Our object came available but we've already got one!? " + this), new Object[0]);
            this._object = null;
        }
        if (!this._pending) {
            Log.log.warning((Object)("J.C. on a pogo stick! Our object came available but we're not pending!? " + this), new Object[0]);
        }
        this._pending = false;
        if (!this._active) {
            DObjectManager omgr = ((DObject)object).getManager();
            if (omgr != null) {
                omgr.unsubscribeFromObject(this._oid, this);
            }
            return;
        }
        this._object = object;
        this._subscriber.objectAvailable(object);
        ChangeListener[] changeListenerArray = this._listeners;
        int n = this._listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeListener listener = changeListenerArray[n2];
            ((DObject)this._object).addListener(listener);
            ++n2;
        }
    }

    @Override
    public void requestFailed(int oid, ObjectAccessException cause) {
        if (!this._pending) {
            Log.log.warning((Object)("Criminy creole! Our subscribe failed but we're not pending!? " + this), new Object[0]);
        }
        this._pending = false;
        if (this._active) {
            this._active = false;
            this._subscriber.requestFailed(oid, cause);
        }
    }

    public String toString() {
        return "[oid=" + this._oid + ", sub=" + StringUtil.shortClassName(this._subscriber) + ", active=" + this._active + ", pending=" + this._pending + ", dobj=" + StringUtil.shortClassName(this._object) + "]";
    }
}

