/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server.net;

import com.google.common.base.Preconditions;
import com.threerings.io.FramedInputStream;
import com.threerings.io.FramingOutputStream;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.nio.conman.Connection;
import com.threerings.nio.conman.ConnectionManager;
import com.threerings.presents.Log;
import com.threerings.presents.net.Message;
import com.threerings.presents.server.net.PresentsConnectionManager;
import com.threerings.presents.util.DatagramSequencer;
import com.threerings.protobuf.io.ProtobufInputStream;
import com.threerings.protobuf.io.ProtobufOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PresentsConnection
extends Connection {
    protected FramedInputStream _fin;
    protected ObjectInputStream _oin;
    protected ObjectOutputStream _oout;
    protected InetSocketAddress _datagramAddress;
    protected DatagramChannel _datagramChannel;
    protected byte[] _datagramSecret;
    protected boolean _transmitDatagrams;
    protected MessageDigest _digest;
    protected DatagramSequencer _sequencer;
    protected MessageHandler _handler;
    protected ClassLoader _loader;
    protected PresentsConnectionManager _pcmgr;

    @Override
    public void init(ConnectionManager cmgr, SocketChannel channel, long createStamp) throws IOException {
        super.init(cmgr, channel, createStamp);
        this._pcmgr = (PresentsConnectionManager)cmgr;
    }

    public void setMessageHandler(MessageHandler handler) {
        this._handler = (MessageHandler)Preconditions.checkNotNull((Object)handler);
    }

    public void clearMessageHandler() {
        this._handler = new MessageHandler(){

            @Override
            public void handleMessage(Message message) {
                Log.log.info((Object)"Dropping message from cleared connection", new Object[]{"conn", this, "msg", message});
            }
        };
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
        if (this._oin != null) {
            this._oin.setClassLoader(loader);
        }
    }

    public void setTransmitDatagrams(boolean transmit) {
        this._transmitDatagrams = transmit;
    }

    public boolean getTransmitDatagrams() {
        return this._transmitDatagrams;
    }

    public InetSocketAddress getDatagramAddress() {
        return this._datagramAddress;
    }

    public DatagramChannel getDatagramChannel() {
        return this._datagramChannel;
    }

    public void setDatagramSecret(String secret) {
        try {
            this._datagramSecret = secret.getBytes("UTF-8");
        }
        catch (Exception e) {
            this._datagramSecret = new byte[0];
        }
    }

    public void postMessage(Message msg) {
        this._pcmgr.postMessage(this, msg);
    }

    public void handleDatagram(InetSocketAddress source, DatagramChannel channel, ByteBuffer buf, long when) {
        if (this._digest == null) {
            try {
                this._digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                Log.log.warning((Object)"Missing MD5 algorithm.", new Object[0]);
                return;
            }
            this._sequencer = this._pcmgr.createDatagramSequencer();
        }
        buf.position(12);
        this._digest.update(buf);
        byte[] hash = this._digest.digest(this._datagramSecret);
        buf.position(4);
        int ii = 0;
        while (ii < 8) {
            if (hash[ii] != buf.get()) {
                Log.log.warning((Object)"Datagram failed hash check", new Object[]{"id", this._connectionId, "source", source});
                return;
            }
            ++ii;
        }
        this._datagramAddress = source;
        this._datagramChannel = channel;
        try {
            Message msg = this._sequencer.readDatagram();
            if (msg == null) {
                return;
            }
            msg.received = when;
            this._handler.handleMessage(msg);
        }
        catch (ClassNotFoundException cnfe) {
            Log.log.warning((Object)"Error reading datagram", new Object[]{"error", cnfe});
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Error reading datagram", new Object[]{"error", ioe});
        }
    }

    @Override
    public int handleEvent(long when) {
        this._lastEvent = when;
        int bytesIn = 0;
        try {
            if (this._fin == null) {
                this._fin = new FramedInputStream();
                this._oin = this.createObjectInputStream(this._fin);
                if (this._loader != null) {
                    this._oin.setClassLoader(this._loader);
                }
            }
            while (this._fin.readFrame(this._channel)) {
                bytesIn = this._fin.available() + 4;
                Message msg = (Message)this._oin.readObject();
                msg.received = when;
                this._handler.handleMessage(msg);
            }
        }
        catch (EOFException eofe) {
            this.close();
        }
        catch (ClassNotFoundException cnfe) {
            Log.log.warning((Object)"Error reading message from socket", new Object[]{"channel", this._channel, "error", cnfe});
            String errmsg = "Unable to decode incoming message.";
            this.networkFailure((IOException)new IOException(errmsg).initCause(cnfe));
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (msg == null || msg.indexOf("reset by peer") == -1) {
                Log.log.warning((Object)"Error reading message from socket", new Object[]{"channel", this._channel, ioe});
            }
            this.networkFailure(ioe);
        }
        return bytesIn;
    }

    protected ObjectInputStream getObjectInputStream() {
        return this._oin;
    }

    protected ObjectInputStream createObjectInputStream(InputStream src) {
        return new ProtobufInputStream(src);
    }

    protected void inheritStreams(PresentsConnection other) {
        this._fin = other._fin;
        this._oin = other._oin;
        this._oout = other._oout;
        if (this._loader != null) {
            this._oin.setClassLoader(this._loader);
        }
    }

    protected ObjectOutputStream getObjectOutputStream(FramingOutputStream fout) {
        if (this._oout == null) {
            this._oout = new ProtobufOutputStream(fout);
        }
        return this._oout;
    }

    protected void setObjectOutputStream(ObjectOutputStream oout) {
        this._oout = oout;
    }

    protected DatagramSequencer getDatagramSequencer() {
        return this._sequencer;
    }

    public static interface MessageHandler {
        public void handleMessage(Message var1);
    }
}

