/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.samskivert.util.Calendars;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.Interval;
import com.samskivert.util.ObserverList;
import com.samskivert.util.StringUtil;
import com.threerings.presents.Log;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.server.PresentsServer;
import com.threerings.util.MessageBundle;

public abstract class RebootManager {
    public static final int[] DEFAULT_WARNINGS = new int[]{120, 90, 60, 30, 20, 15, 10, 5, 2, 1};
    protected PresentsServer _server;
    protected RootDObjectManager _omgr;
    protected long _nextReboot;
    protected String _initiator;
    protected boolean _rebootSoon = false;
    protected Interval _interval;
    protected ObserverList<PendingShutdownObserver> _observers = ObserverList.newFastUnsafe();
    protected int _nextRebootLockId = 0;
    protected HashIntMap<String> _rebootLocks = new HashIntMap();
    protected static final String AUTOMATIC_INITIATOR = "automatic";

    public void init() {
        this.scheduleRegularReboot();
    }

    public boolean scheduleRegularReboot() {
        int freq = this.getDayFrequency();
        if (freq == -1) {
            return false;
        }
        Calendars.Builder cal = Calendars.now().zeroTime().addHours(this.getRebootHour()).addDays(freq);
        if (this.getSkipWeekends()) {
            int dow = cal.get(7);
            switch (dow) {
                case 7: {
                    if (freq <= 1) break;
                    cal.addDays(-1);
                    break;
                }
                case 1: {
                    if (freq <= 2) break;
                    cal.addDays(-2);
                }
            }
        }
        this.scheduleReboot(cal.toTime(), AUTOMATIC_INITIATOR);
        return true;
    }

    public boolean willShutdownSoon() {
        return this._rebootSoon;
    }

    public void addObserver(PendingShutdownObserver observer) {
        this._observers.add((Object)observer);
    }

    public void scheduleReboot(long rebootTime, String initiator) {
        if (this._interval != null) {
            this._interval.cancel();
            this._interval = null;
        }
        this._nextReboot = rebootTime;
        this._initiator = initiator;
        long now = System.currentTimeMillis();
        int[] warnings = this.getWarnings();
        int ii = warnings.length - 1;
        while (ii >= 0) {
            long warnTime = warnings[ii] * 60 * 1000;
            if (now + warnTime >= this._nextReboot) {
                this.doWarning(ii);
                return;
            }
            --ii;
        }
        this._rebootSoon = false;
        long firstWarnTime = this._nextReboot - (long)(warnings[0] * 60 * 1000) - now;
        this._interval = this._omgr.newInterval(new Runnable(){

            @Override
            public void run() {
                RebootManager.this.doWarning(0);
            }
        });
        this._interval.schedule(firstWarnTime);
    }

    public int preventReboot(String whereFrom) {
        if (whereFrom == null) {
            throw new IllegalArgumentException("whereFrom must be descriptive.");
        }
        int lockId = this._nextRebootLockId++;
        this._rebootLocks.put(lockId, (Object)whereFrom);
        return lockId;
    }

    public void allowReboot(int lockId) {
        if (this._rebootLocks.remove(lockId) == null) {
            throw new IllegalArgumentException("no such lockId (" + lockId + ")");
        }
    }

    public int[] getWarnings() {
        return DEFAULT_WARNINGS;
    }

    protected RebootManager(PresentsServer server, RootDObjectManager omgr) {
        this._server = server;
        this._omgr = omgr;
    }

    protected abstract void broadcast(String var1);

    protected abstract int getDayFrequency();

    protected abstract int getRebootHour();

    protected abstract boolean getSkipWeekends();

    protected abstract String getCustomRebootMessage();

    protected String getRebootMessage(String key, int minutes) {
        String msg = this.getCustomRebootMessage();
        if (StringUtil.isBlank((String)msg)) {
            msg = "m.reboot_msg_standard";
        }
        return MessageBundle.compose((String)key, (String[])new String[]{MessageBundle.taint((Object)("" + minutes)), msg});
    }

    protected void doWarning(final int level) {
        this._rebootSoon = true;
        int[] warnings = this.getWarnings();
        if (level == warnings.length) {
            if (this.checkLocks()) {
                return;
            }
            Log.log.info((Object)("Performing automatic server reboot/shutdown, as scheduled by: " + this._initiator), new Object[0]);
            this.broadcast("m.rebooting_now");
            new Interval(Interval.RUN_DIRECT){

                public void expired() {
                    RebootManager.this._server.queueShutdown();
                }
            }.schedule(1000L);
            return;
        }
        int minutes = warnings[level];
        this.broadcast(this.getRebootMessage("m.reboot_warning", minutes));
        if (level < warnings.length - 1) {
            minutes -= warnings[level + 1];
        }
        this._interval = this._omgr.newInterval(new Runnable(){

            @Override
            public void run() {
                RebootManager.this.doWarning(level + 1);
            }
        });
        this._interval.schedule((long)(minutes * 60 * 1000));
        this.notifyObservers(level);
    }

    protected boolean checkLocks() {
        if (this._rebootLocks.isEmpty()) {
            return false;
        }
        Log.log.info((Object)"Reboot delayed due to outstanding locks", new Object[]{"locks", this._rebootLocks.elements()});
        this.broadcast("m.reboot_delayed");
        this._interval = this._omgr.newInterval(new Runnable(){

            @Override
            public void run() {
                RebootManager.this.doWarning(RebootManager.this.getWarnings().length);
            }
        });
        this._interval.schedule(60000L);
        return true;
    }

    protected void notifyObservers(int level) {
        int[] warnings = this.getWarnings();
        final int warningsLeft = warnings.length - level - 1;
        final long msLeft = 60000L * (long)warnings[level];
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<PendingShutdownObserver>(){

            public boolean apply(PendingShutdownObserver observer) {
                observer.shutdownPlanned(warningsLeft, msLeft);
                return true;
            }
        });
    }

    public static interface PendingShutdownObserver {
        public void shutdownPlanned(int var1, long var2);
    }
}

