/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.hexnova.narya.event.data.EntryAddedEvent;
import com.samskivert.util.StringUtil;
import com.threerings.presents.annotation.Transient;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.EntryEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.SetListener;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.protobuf.io.ProtobufRegistry;
import java.io.IOException;

public class EntryAddedEvent<T extends DSet.Entry>
extends EntryEvent<T>
implements ProtobufProvider<com.hexnova.narya.event.data.EntryAddedEvent> {
    protected T _entry;
    protected transient boolean _alreadyApplied;
    @Transient
    private EntryAddedEvent.Builder builder = null;

    public EntryAddedEvent(int targetOid, String name, T entry) {
        super(targetOid, name);
        this._entry = entry;
    }

    public EntryAddedEvent() {
    }

    @Override
    public Comparable<?> getKey() {
        return this._entry.getKey();
    }

    @Override
    public T getEntry() {
        return this._entry;
    }

    @Override
    public T getOldEntry() {
        return null;
    }

    @Override
    public boolean alreadyApplied() {
        return this._alreadyApplied;
    }

    @Override
    public boolean applyToObject(DObject target) throws ObjectAccessException {
        return this._alreadyApplied || target.getSet(this._name).add(this._entry);
    }

    @Override
    protected void notifyListener(Object listener) {
        if (listener instanceof SetListener) {
            SetListener setlist = (SetListener)listener;
            setlist.entryAdded(this);
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        buf.append("ELADD:");
        super.toString(buf);
        buf.append(", entry=");
        StringUtil.toString((StringBuilder)buf, this._entry);
    }

    protected EntryAddedEvent<T> setAlreadyApplied(boolean alreadyApplied) {
        this._alreadyApplied = alreadyApplied;
        return this;
    }

    public EntryAddedEvent.Builder getBuilder() {
        if (this.builder == null) {
            this.builder = com.hexnova.narya.event.data.EntryAddedEvent.newBuilder();
        }
        return this.builder;
    }

    @Override
    public void populate(com.hexnova.narya.event.data.EntryAddedEvent message) throws IOException {
        this._toid = (short)message.getToid();
        this._name = message.getName();
        if (message.hasEntry()) {
            this._entry = (DSet.Entry)ProtobufRegistry.fromAnyMessage(message.getEntry());
        }
    }

    @Override
    public com.hexnova.narya.event.data.EntryAddedEvent transform() throws IOException {
        EntryAddedEvent.Builder builder = this.getBuilder();
        builder.setToid(this._toid);
        builder.setName(this._name);
        if (this._entry != null) {
            builder.setEntry(ProtobufRegistry.toAnyMessage(this._entry));
        }
        return builder.build();
    }
}

