/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.hexnova.narya.event.data.CompoundEvent;
import com.hexnova.narya.util.AnyMessage;
import com.threerings.presents.annotation.Transient;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.net.Transport;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.protobuf.io.ProtobufRegistry;
import com.threerings.util.StreamableArrayList;
import java.io.IOException;
import java.util.List;

public class CompoundEvent
extends DEvent
implements ProtobufProvider<com.hexnova.narya.event.data.CompoundEvent> {
    protected transient DObjectManager _omgr;
    protected transient DObject _target;
    protected StreamableArrayList<DEvent> _events;
    @Transient
    private CompoundEvent.Builder builder;

    public CompoundEvent(DObject target, DObjectManager omgr) {
        super(target.getOid());
        if (omgr == null) {
            String errmsg = "Must receive non-null object manager reference";
            throw new IllegalArgumentException(errmsg);
        }
        this._omgr = omgr;
        this._target = target;
        this._events = StreamableArrayList.newList();
    }

    public CompoundEvent(int oid) {
        super(oid);
        this._events = StreamableArrayList.newList();
    }

    public CompoundEvent() {
        super(0);
    }

    public void postEvent(DEvent event) {
        this._events.add(event);
    }

    public List<DEvent> getEvents() {
        return this._events;
    }

    public void commit() {
        this.clearTarget();
        int size = this._events.size();
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                this._omgr.postEvent((DEvent)this._events.get(0));
                break;
            }
            default: {
                this._transport = ((DEvent)this._events.get(0)).getTransport();
                int ii = 1;
                while (ii < size) {
                    this._transport = ((DEvent)this._events.get(ii)).getTransport().combine(this._transport);
                    ++ii;
                }
                this._omgr.postEvent(this);
            }
        }
    }

    public void cancel() {
        this.clearTarget();
        this._events.clear();
    }

    @Override
    public void setSourceOid(int sourceOid) {
        super.setSourceOid(sourceOid);
        int ecount = this._events.size();
        int ii = 0;
        while (ii < ecount) {
            ((DEvent)this._events.get(ii)).setSourceOid(sourceOid);
            ++ii;
        }
    }

    @Override
    public void setTargetOid(int targetOid) {
        super.setTargetOid(targetOid);
        int ecount = this._events.size();
        int ii = 0;
        while (ii < ecount) {
            ((DEvent)this._events.get(ii)).setTargetOid(targetOid);
            ++ii;
        }
    }

    @Override
    public DEvent setTransport(Transport transport) {
        super.setTransport(transport);
        int ii = 0;
        int nn = this._events.size();
        while (ii < nn) {
            ((DEvent)this._events.get(ii)).setTransport(transport);
            ++ii;
        }
        return this;
    }

    @Override
    public boolean applyToObject(DObject target) throws ObjectAccessException {
        return false;
    }

    protected void clearTarget() {
        if (this._target != null) {
            this._target.clearTransaction();
            this._target = null;
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        buf.append("COMPOUND:");
        super.toString(buf);
        int ii = 0;
        int nn = this._events.size();
        while (ii < nn) {
            buf.append(", ").append(this._events.get(ii));
            ++ii;
        }
    }

    @Override
    public void populate(com.hexnova.narya.event.data.CompoundEvent proto) {
        if (this._events == null) {
            this._events = StreamableArrayList.newList();
        }
        this._toid = proto.getToid();
        if (proto.getEventsCount() > 0) {
            int i = 0;
            while (i < proto.getEventsCount()) {
                AnyMessage any = proto.getEvents(i);
                try {
                    DEvent message = (DEvent)ProtobufRegistry.fromAnyMessage(any);
                    this._events.add(message);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    @Override
    public com.hexnova.narya.event.data.CompoundEvent transform() throws IOException {
        CompoundEvent.Builder builder = this.getBuilder();
        if (this._events != null && this._events.size() > 0) {
            for (DEvent msg : this._events) {
                AnyMessage any = ProtobufRegistry.toAnyMessage(msg);
                if (any == null) continue;
                builder.addEvents(any);
            }
        }
        builder.setToid(this._toid);
        return builder.build();
    }

    public CompoundEvent.Builder getBuilder() {
        if (this.builder == null) {
            this.builder = com.hexnova.narya.event.data.CompoundEvent.newBuilder();
        } else {
            this.builder.clear();
        }
        return this.builder;
    }
}

