/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.threerings.presents.dobj.DObject;
import java.lang.reflect.Field;

public abstract class Accessor
implements Comparable<Accessor> {
    public final String name;

    public abstract Object get(DObject var1);

    public abstract void set(DObject var1, Object var2);

    @Override
    public int compareTo(Accessor other) {
        return this.name.compareTo(other.name);
    }

    protected Accessor(String name) {
        this.name = name;
    }

    public static class ByField
    extends Accessor {
        public final Field field;

        public ByField(Field field) {
            super(field.getName());
            this.field = field;
        }

        @Override
        public Object get(DObject obj) {
            try {
                return this.field.get(obj);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
        }

        @Override
        public void set(DObject obj, Object value) {
            try {
                this.field.set(obj, value);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
        }
    }
}

