/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.client;

import com.samskivert.util.RunAnywhere;
import com.threerings.presents.client.PingPongObserver;
import com.threerings.presents.net.PingRequest;
import com.threerings.presents.net.PongResponse;

public class ServerTimeCalculator
extends Thread
implements PingPongObserver {
    protected PingRequest _ping;
    protected long _lastTick = RunAnywhere.currentTimeMillis();
    protected long _serverTime;

    public ServerTimeCalculator() {
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    ServerTimeCalculator.sleep(100L);
                    long now = RunAnywhere.currentTimeMillis();
                    long deta = now - this._lastTick;
                    this._serverTime += deta;
                    this._lastTick = now;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public void sentPing(PingRequest ping) {
        this._ping = ping;
    }

    @Override
    public void gotPong(PongResponse pong) {
        if (this._ping == null) {
            return;
        }
        if (this._ping.messageId != pong.messageId) {
            return;
        }
        long send = this._ping.getPackStamp();
        long recv = pong.getUnpackStamp();
        this._ping = null;
        long server = pong.getPackStamp();
        long delay = pong.getProcessDelay();
        long nettime = (recv - send - delay) / 2L;
        this.setServerTime(server + nettime);
    }

    public void setServerTime(long serverTime) {
        this._serverTime = serverTime;
        this._lastTick = RunAnywhere.currentTimeMillis();
    }

    public long getServerTime() {
        return this._serverTime;
    }
}

