/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.client;

import com.threerings.presents.Log;
import com.threerings.presents.net.PingRequest;
import com.threerings.presents.net.PongResponse;
import java.util.Arrays;

public class DeltaCalculator {
    protected int _iter;
    protected long[] _deltas = new long[3];
    protected PingRequest _ping;
    protected static final int CLOCK_SYNC_PING_COUNT = 3;

    public boolean shouldSendPing() {
        return this._ping == null && !this.isDone();
    }

    public void sentPing(PingRequest ping) {
        this._ping = ping;
    }

    public boolean gotPong(PongResponse pong) {
        if (this._ping == null) {
            return false;
        }
        if (this._iter >= this._deltas.length) {
            return true;
        }
        long send = this._ping.getPackStamp();
        long recv = pong.getUnpackStamp();
        this._ping = null;
        long server = pong.getPackStamp();
        long delay = pong.getProcessDelay();
        long nettime = (recv - send - delay) / 2L;
        this._deltas[this._iter] = recv - (server + nettime);
        Log.log.debug((Object)"Calculated delta", new Object[]{"delay", delay, "nettime", nettime, "delta", this._deltas[this._iter], "rtt", recv - send});
        return ++this._iter >= 3;
    }

    public long getTimeDelta() {
        if (this._iter == 0) {
            return 0L;
        }
        long[] deltasCopy = new long[this._iter];
        System.arraycopy(this._deltas, 0, deltasCopy, 0, this._iter);
        Arrays.sort(deltasCopy);
        return deltasCopy[deltasCopy.length / 2];
    }

    public boolean isDone() {
        return this._iter >= 3;
    }
}

