/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.client;

import com.samskivert.util.BasicRunQueue;
import com.samskivert.util.Config;
import com.samskivert.util.RunQueue;
import com.threerings.crowd.Log;
import com.threerings.crowd.chat.client.ChatDirector;
import com.threerings.crowd.client.LocationDirector;
import com.threerings.crowd.client.OccupantDirector;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.ClientObserver;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.net.UsernamePasswordCreds;
import com.threerings.resource.ResourceManager;
import com.threerings.resource.file.FileResourceManager;
import com.threerings.util.MessageManager;
import com.threerings.util.Name;
import java.awt.EventQueue;

public class TestClient
implements ClientObserver {
    protected Client _client;
    protected CrowdContext _ctx;
    protected LocationDirector _locdir;
    protected OccupantDirector _occdir;
    protected MessageManager _msgmgr;
    protected ChatDirector _chatdir;
    protected ResourceManager _rsrcmgr;
    protected BasicRunQueue _rqueue = new BasicRunQueue(){

        public void postRunnable(Runnable r) {
            EventQueue.invokeLater(r);
        }
    };

    public TestClient(String username, String password) {
        this._ctx = this.createContext();
        this._client = this.createClient(username, password);
        this._locdir = this.createLocationDirector(this._ctx);
        this._occdir = this.createOccupantDirector(this._ctx);
        this._rsrcmgr = new FileResourceManager("rsrc/");
        this._msgmgr = new MessageManager("i18n", this._rsrcmgr);
        this._chatdir = new ChatDirector(this._ctx, "global");
        this._client.addClientObserver(this);
        this._client.setServer("localhost", Client.DEFAULT_SERVER_PORTS);
    }

    protected LocationDirector createLocationDirector(CrowdContext ctx) {
        return new LocationDirector(ctx);
    }

    protected OccupantDirector createOccupantDirector(CrowdContext ctx) {
        return new OccupantDirector(ctx);
    }

    protected Client createClient(String username, String password) {
        return new Client(new UsernamePasswordCreds(new Name(username), password), (RunQueue)this._rqueue);
    }

    public void run() {
        this._client.logon();
        this._rqueue.run();
    }

    @Override
    public void clientWillLogon(Client client) {
    }

    @Override
    public void clientDidLogon(Client client) {
        Log.log.info((Object)("Client did logon [client=" + client + "]."), new Object[0]);
        this._ctx.getLocationDirector().moveTo(15);
    }

    @Override
    public void clientObjectDidChange(Client client) {
        Log.log.info((Object)("Client object did change [client=" + client + "]."), new Object[0]);
    }

    @Override
    public void clientFailedToLogon(Client client, Exception cause) {
        Log.log.info((Object)("Client failed to logon [client=" + client + ", cause=" + cause + "]."), new Object[0]);
    }

    @Override
    public void clientConnectionFailed(Client client, Exception cause) {
        Log.log.info((Object)("Client connection failed [client=" + client + ", cause=" + cause + "]."), new Object[0]);
    }

    @Override
    public boolean clientWillLogoff(Client client) {
        Log.log.info((Object)("Client will logoff [client=" + client + "]."), new Object[0]);
        return true;
    }

    @Override
    public void clientDidLogoff(Client client) {
        Log.log.info((Object)("Client did logoff [client=" + client + "]."), new Object[0]);
        System.exit(0);
    }

    @Override
    public void clientDidClear(Client client) {
    }

    protected CrowdContext createContext() {
        return new CrowdContextImpl();
    }

    public static void main(String[] args) {
        TestClient tclient = new TestClient("test", "test");
        tclient.run();
    }

    protected class CrowdContextImpl
    implements CrowdContext {
        protected CrowdContextImpl() {
        }

        @Override
        public Config getConfig() {
            return null;
        }

        @Override
        public Client getClient() {
            return TestClient.this._client;
        }

        @Override
        public DObjectManager getDObjectManager() {
            return TestClient.this._client.getDObjectManager();
        }

        @Override
        public LocationDirector getLocationDirector() {
            return TestClient.this._locdir;
        }

        @Override
        public OccupantDirector getOccupantDirector() {
            return TestClient.this._occdir;
        }

        @Override
        public ChatDirector getChatDirector() {
            return TestClient.this._chatdir;
        }

        @Override
        public MessageManager getMessageManager() {
            return TestClient.this._msgmgr;
        }

        @Override
        public void setPlaceView(PlaceView view) {
        }

        @Override
        public void clearPlaceView(PlaceView view) {
        }
    }
}

